/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.simulator.core.script.nashorn;

import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import javax.script.ScriptEngine;
import jdk.nashorn.api.scripting.ClassFilter;
import jdk.nashorn.api.scripting.JSObject;
import jdk.nashorn.api.scripting.NashornScriptEngineFactory;
import jdk.nashorn.internal.runtime.Undefined;
import org.jetlinks.simulator.core.script.jsr223.JavaScriptFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NashornScriptFactory
extends JavaScriptFactory
implements ClassFilter {
    private static final Logger log = LoggerFactory.getLogger(NashornScriptFactory.class);

    @Override
    protected ScriptEngine createEngine() {
        return new NashornScriptEngineFactory().getScriptEngine(new String[]{"-doe", "--language=es6", "--global-per-engine"}, NashornScriptFactory.class.getClassLoader(), (ClassFilter)this);
    }

    public boolean exposeToScripts(String s2) {
        return !this.isDenied(s2);
    }

    @Override
    protected boolean valueIsUndefined(Object value) {
        return value == null || value instanceof Undefined;
    }

    @Override
    public Object convertToJavaType(Object value) {
        return NashornScriptFactory.convertToJavaObject(value);
    }

    public static Object convertToJavaObject(Object object) {
        if (object instanceof JSObject) {
            return NashornScriptFactory.convertJSObject((JSObject)object);
        }
        if (object instanceof Undefined) {
            return null;
        }
        return object;
    }

    public static Object convertJSObject(JSObject jsObject) {
        if (jsObject.isArray()) {
            return jsObject.values().stream().map(obj -> {
                if (obj instanceof JSObject) {
                    return NashornScriptFactory.convertJSObject((JSObject)obj);
                }
                return obj;
            }).collect(Collectors.toList());
        }
        if (jsObject instanceof Map) {
            HashMap newMap = new HashMap(((Map)jsObject).size());
            for (Map.Entry entry : ((Map)jsObject).entrySet()) {
                Object val = entry.getValue();
                if (val instanceof JSObject) {
                    val = NashornScriptFactory.convertJSObject((JSObject)val);
                }
                newMap.put(entry.getKey(), val);
            }
            return newMap;
        }
        throw new UnsupportedOperationException("unsupported type:" + jsObject);
    }
}

