/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.simulator.cmd.http;

import java.net.URL;
import java.time.Duration;
import java.util.Map;
import org.jetlinks.simulator.cmd.AbstractCommand;
import org.jetlinks.simulator.cmd.NetClientCommandOption;
import org.jetlinks.simulator.core.ExceptionUtils;
import org.jetlinks.simulator.core.network.http.HTTPClient;
import org.jetlinks.simulator.core.network.http.HTTPClientOptions;
import org.springframework.http.HttpHeaders;
import picocli.CommandLine;

@CommandLine.Command(name="create", showDefaultValues=true, description={"Create HTTP Client"}, headerHeading="%n", sortOptions=false)
public class CreateHttpCommand
extends AbstractCommand
implements Runnable {
    @CommandLine.Mixin
    private NetClientCommandOption common;
    @CommandLine.Mixin
    private Options options;

    @Override
    public void run() {
        if (null != this.common) {
            this.common.apply(this.options);
        }
        this.printf("create http client %s", this.options.getId());
        try {
            HTTPClient client = HTTPClient.create(this.options).block(Duration.ofSeconds(10L));
            if (client != null) {
                this.main().connectionManager().addConnection(client);
                this.printf(" success!%n", new Object[0]);
                this.main().getCommandLine().execute("http", "attach", client.getId());
            } else {
                this.printf(" error:%n", new Object[0]);
            }
        }
        catch (Throwable err) {
            this.printfError(" error: %s %n", ExceptionUtils.getErrorMessage(err));
        }
    }

    static class Options
    extends HTTPClientOptions {
        Options() {
        }

        @Override
        @CommandLine.Option(names={"--id"}, description={"Client ID"}, defaultValue="http-client")
        public void setId(String id) {
            super.setId(id);
        }

        @CommandLine.Option(names={"-h", "--header"}, description={"Default Headers"})
        public void setHeader(Map<String, String> header) {
            HttpHeaders headers2 = new HttpHeaders();
            header.forEach(headers2::add);
            this.setHeaders(headers2);
        }

        @CommandLine.Parameters(paramLabel="URL", description={"URL,start with http or https"})
        public void setBasePath0(URL basePath) {
            super.setBasePath(basePath.toString());
        }
    }

    public static class HttpHeaderConverter
    implements CommandLine.ITypeConverter<HttpHeaders> {
        @Override
        public HttpHeaders convert(String value) throws Exception {
            HttpHeaders headers2 = new HttpHeaders();
            for (String s2 : value.split(",")) {
                String[] split2 = s2.split("=", 2);
                if (split2.length != 2) continue;
                headers2.add(split2[0], split2[1]);
            }
            return headers2;
        }
    }
}

