/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.core;

import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import org.jetlinks.core.SimpleValues;
import org.jetlinks.core.Value;
import org.jetlinks.core.config.ConfigKey;

public interface Values {
    public Map<String, Object> getAllValues();

    public Optional<Value> getValue(String var1);

    public Values merge(Values var1);

    public int size();

    public Collection<String> getNonExistentKeys(Collection<String> var1);

    default public boolean isEmpty() {
        return this.size() == 0;
    }

    default public boolean isNoEmpty() {
        return this.size() > 0;
    }

    default public <T> Optional<T> getValue(ConfigKey<T> key) {
        return this.getValue(key.getKey()).map(val -> val.as(key.getValueType()));
    }

    default public String getString(String key, Supplier<String> defaultValue) {
        return this.getValue(key).map(Value::asString).orElseGet(defaultValue);
    }

    default public String getString(String key, String defaultValue) {
        return this.getString(key, () -> defaultValue);
    }

    default public Number getNumber(String key, Supplier<Number> defaultValue) {
        return this.getValue(key).map(Value::asNumber).orElseGet(defaultValue);
    }

    default public Number getNumber(String key, Number defaultValue) {
        return this.getNumber(key, () -> defaultValue);
    }

    public static Values of(Map<String, ?> values) {
        return SimpleValues.of(values);
    }
}

