/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.core.defaults;

import javax.annotation.Nonnull;
import org.jetlinks.core.device.DeviceInfo;
import org.jetlinks.core.device.DeviceRegistry;
import org.jetlinks.core.device.DeviceThingType;
import org.jetlinks.core.device.ProductInfo;
import org.jetlinks.core.things.Thing;
import org.jetlinks.core.things.ThingInfo;
import org.jetlinks.core.things.ThingTemplate;
import org.jetlinks.core.things.ThingTemplateInfo;
import org.jetlinks.core.things.ThingsRegistrySupport;
import reactor.core.publisher.Mono;

public class DeviceThingsRegistrySupport
implements ThingsRegistrySupport {
    private final DeviceRegistry registry;

    public void checkThingType(String type) {
        if (!DeviceThingType.device.getId().equals(type)) {
            throw new UnsupportedOperationException("unsupported thing type:" + type);
        }
    }

    @Override
    public Mono<Thing> getThing(@Nonnull String thingType, @Nonnull String thingId) {
        this.checkThingType(thingType);
        return this.registry.getDevice(thingId).cast(Thing.class);
    }

    @Override
    public Mono<ThingTemplate> getTemplate(@Nonnull String thingType, @Nonnull String templateId) {
        return this.registry.getProduct(templateId).cast(ThingTemplate.class);
    }

    @Override
    public Mono<Thing> register(@Nonnull String thingType, @Nonnull ThingInfo info) {
        this.checkThingType(thingType);
        return this.registry.register(DeviceInfo.builder().id(info.getId()).productId(info.getTemplateId()).metadata(info.getMetadata()).configuration(info.getConfiguration()).build()).cast(Thing.class);
    }

    @Override
    public Mono<Void> unregisterThing(@Nonnull String thingType, @Nonnull String thingId) {
        this.checkThingType(thingType);
        return this.registry.unregisterDevice(thingId);
    }

    @Override
    public Mono<ThingTemplate> register(@Nonnull String thingType, @Nonnull ThingTemplateInfo templateInfo) {
        this.checkThingType(thingType);
        return this.registry.register(ProductInfo.builder().id(templateInfo.getId()).metadata(templateInfo.getMetadata()).configuration(templateInfo.getConfiguration()).build()).cast(ThingTemplate.class);
    }

    @Override
    public Mono<Void> unregisterTemplate(@Nonnull String thingType, @Nonnull String templateId) {
        this.checkThingType(thingType);
        return this.registry.unregisterProduct(templateId);
    }

    @Override
    public boolean isSupported(String thingType) {
        return DeviceThingType.device.getId().equals(thingType);
    }

    public DeviceThingsRegistrySupport(DeviceRegistry registry) {
        this.registry = registry;
    }
}

