/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.reactive.result.method.annotation;

import java.util.Map;
import org.springframework.core.MethodParameter;
import org.springframework.core.ReactiveAdapterRegistry;
import org.springframework.util.MultiValueMap;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.reactive.BindingContext;
import org.springframework.web.reactive.result.method.HandlerMethodArgumentResolverSupport;
import org.springframework.web.reactive.result.method.SyncHandlerMethodArgumentResolver;
import org.springframework.web.server.ServerWebExchange;

public class RequestParamMapMethodArgumentResolver
extends HandlerMethodArgumentResolverSupport
implements SyncHandlerMethodArgumentResolver {
    public RequestParamMapMethodArgumentResolver(ReactiveAdapterRegistry adapterRegistry) {
        super(adapterRegistry);
    }

    @Override
    public boolean supportsParameter(MethodParameter param) {
        return this.checkAnnotatedParamNoReactiveWrapper(param, RequestParam.class, this::allParams);
    }

    private boolean allParams(RequestParam requestParam, Class<?> type) {
        return Map.class.isAssignableFrom(type) && !StringUtils.hasText(requestParam.name());
    }

    @Override
    public Object resolveArgumentValue(MethodParameter methodParameter, BindingContext context, ServerWebExchange exchange2) {
        boolean isMultiValueMap = MultiValueMap.class.isAssignableFrom(methodParameter.getParameterType());
        MultiValueMap<String, String> queryParams = exchange2.getRequest().getQueryParams();
        return isMultiValueMap ? queryParams : queryParams.toSingleValueMap();
    }
}

