/*
 * Decompiled with CFR 0.152.
 */
package reactor.swing;

import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import reactor.core.Disposable;
import reactor.core.Exceptions;
import reactor.core.publisher.Operators;
import reactor.core.scheduler.Scheduler;
import reactor.util.context.Context;

public final class SwingScheduler
implements Scheduler {
    public static Scheduler create() {
        return new SwingScheduler();
    }

    SwingScheduler() {
    }

    @Override
    public Disposable schedule(Runnable task) {
        SwingScheduledDirectAction a = new SwingScheduledDirectAction(task);
        SwingUtilities.invokeLater(a);
        return a;
    }

    @Override
    public Disposable schedule(Runnable task, long delay, TimeUnit unit) {
        if (delay <= 0L) {
            return this.schedule(task);
        }
        Timer timer = new Timer((int)unit.toMillis(delay), null);
        timer.setRepeats(false);
        timer.addActionListener(e -> {
            try {
                task.run();
            }
            catch (Throwable ex) {
                Exceptions.throwIfFatal(ex);
                Operators.onErrorDropped(ex, Context.empty());
            }
        });
        timer.start();
        return timer::stop;
    }

    @Override
    public Disposable schedulePeriodically(Runnable task, long initialDelay, long period, TimeUnit unit) {
        Timer timer = new Timer((int)unit.toMillis(period), null);
        timer.setInitialDelay((int)unit.toMillis(initialDelay));
        timer.addActionListener(e -> {
            try {
                task.run();
            }
            catch (Throwable ex) {
                timer.stop();
                Exceptions.throwIfFatal(ex);
                Operators.onErrorDropped(ex, Context.empty());
            }
        });
        timer.start();
        return timer::stop;
    }

    @Override
    public Scheduler.Worker createWorker() {
        return new SwingSchedulerWorker();
    }

    static final class SwingScheduledDirectAction
    extends AtomicBoolean
    implements Runnable,
    Disposable {
        private static final long serialVersionUID = 2378266891882031635L;
        final Runnable action;

        public SwingScheduledDirectAction(Runnable action) {
            this.action = action;
        }

        @Override
        public void run() {
            if (!this.get()) {
                try {
                    this.action.run();
                }
                catch (Throwable ex) {
                    Exceptions.throwIfFatal(ex);
                    Operators.onErrorDropped(ex, Context.empty());
                }
            }
        }

        @Override
        public void dispose() {
            this.set(true);
        }
    }

    static final class SwingSchedulerWorker
    implements Scheduler.Worker {
        volatile boolean unsubscribed;
        Set<Timer> tasks = new HashSet<Timer>();

        SwingSchedulerWorker() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void dispose() {
            Set<Timer> set;
            if (this.unsubscribed) {
                return;
            }
            this.unsubscribed = true;
            SwingSchedulerWorker swingSchedulerWorker = this;
            synchronized (swingSchedulerWorker) {
                set = this.tasks;
                this.tasks = null;
            }
            if (set != null) {
                for (Timer t : set) {
                    t.stop();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void remove(Timer timer) {
            if (this.unsubscribed) {
                return;
            }
            SwingSchedulerWorker swingSchedulerWorker = this;
            synchronized (swingSchedulerWorker) {
                if (this.unsubscribed) {
                    return;
                }
                this.tasks.remove(timer);
            }
        }

        @Override
        public Disposable schedule(Runnable action) {
            if (!this.unsubscribed) {
                SwingScheduledDirectAction a = new SwingScheduledDirectAction(action);
                SwingUtilities.invokeLater(a);
                return a;
            }
            throw Exceptions.failWithRejected();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Disposable schedule(Runnable action, long delayTime, TimeUnit unit) {
            if (delayTime <= 0L) {
                return this.schedule(action);
            }
            if (this.unsubscribed) {
                throw Exceptions.failWithRejected();
            }
            Timer timer = new Timer((int)unit.toMillis(delayTime), null);
            timer.setRepeats(false);
            SwingSchedulerWorker swingSchedulerWorker = this;
            synchronized (swingSchedulerWorker) {
                if (this.unsubscribed) {
                    throw Exceptions.failWithRejected();
                }
                this.tasks.add(timer);
            }
            timer.addActionListener(e -> {
                try {
                    try {
                        action.run();
                    }
                    catch (Throwable ex) {
                        Exceptions.throwIfFatal(ex);
                        Operators.onErrorDropped(ex, Context.empty());
                    }
                }
                finally {
                    this.remove(timer);
                }
            });
            timer.start();
            if (this.unsubscribed) {
                timer.stop();
                throw Exceptions.failWithRejected();
            }
            return () -> {
                timer.stop();
                this.remove(timer);
            };
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Disposable schedulePeriodically(Runnable task, long initialDelay, long period, TimeUnit unit) {
            if (this.unsubscribed) {
                throw Exceptions.failWithRejected();
            }
            Timer timer = new Timer((int)unit.toMillis(period), null);
            timer.setInitialDelay((int)unit.toMillis(initialDelay));
            SwingSchedulerWorker swingSchedulerWorker = this;
            synchronized (swingSchedulerWorker) {
                if (this.unsubscribed) {
                    throw Exceptions.failWithRejected();
                }
                this.tasks.add(timer);
            }
            timer.addActionListener(e -> {
                try {
                    task.run();
                }
                catch (Throwable ex) {
                    timer.stop();
                    this.remove(timer);
                    Exceptions.throwIfFatal(ex);
                    Operators.onErrorDropped(ex, Context.empty());
                }
            });
            timer.start();
            if (this.unsubscribed) {
                timer.stop();
                throw Exceptions.failWithRejected();
            }
            return () -> {
                timer.stop();
                this.remove(timer);
            };
        }
    }
}

