/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.core.message.property;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.List;
import java.util.Map;
import org.jetlinks.core.message.MessageType;
import org.jetlinks.core.message.ThingMessage;
import org.jetlinks.core.message.property.DefaultReportPropertyMessage;
import org.jetlinks.core.message.property.PropertyMessage;
import org.jetlinks.core.message.property.ReportPropertyMessage;
import org.jetlinks.core.things.ThingProperty;
import org.jetlinks.core.things.ThingType;

public interface ThingReportPropertyMessage
extends ThingMessage,
PropertyMessage {
    @Override
    public Map<String, Object> getProperties();

    @Override
    public Map<String, Long> getPropertySourceTimes();

    @Override
    public Map<String, String> getPropertyStates();

    public ThingReportPropertyMessage success(Map<String, Object> var1);

    public ThingReportPropertyMessage success(List<ThingProperty> var1);

    @Override
    default public MessageType getMessageType() {
        return MessageType.REPORT_PROPERTY;
    }

    public static ReportPropertyMessage forDevice(String deviceId) {
        ReportPropertyMessage message = new ReportPropertyMessage();
        message.setDeviceId(deviceId);
        return message;
    }

    public static DefaultReportPropertyMessage forThing(ThingType thingType, String deviceId) {
        DefaultReportPropertyMessage message = new DefaultReportPropertyMessage();
        message.setThingId(deviceId);
        message.setThingType(thingType.getId());
        return message;
    }

    @Override
    default public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        ThingMessage.super.readExternal(in);
        PropertyMessage.super.readExternal(in);
    }

    @Override
    default public void writeExternal(ObjectOutput out) throws IOException {
        ThingMessage.super.writeExternal(out);
        PropertyMessage.super.writeExternal(out);
    }
}

