/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.web.validator;

import java.util.Set;
import javax.validation.Configuration;
import javax.validation.ConstraintViolation;
import javax.validation.Validation;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;
import org.hswebframework.web.exception.ValidationException;
import org.hswebframework.web.i18n.ContextLocaleResolver;

public final class ValidatorUtils {
    static volatile Validator validator;

    private ValidatorUtils() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Validator getValidator() {
        if (validator == null) {
            Class<ValidatorUtils> clazz = ValidatorUtils.class;
            synchronized (ValidatorUtils.class) {
                if (validator != null) {
                    // ** MonitorExit[var0] (shouldn't be in output)
                    return validator;
                }
                Configuration<?> configuration = Validation.byDefaultProvider().configure();
                configuration.addProperty("hibernate.validator.locale_resolver", ContextLocaleResolver.class.getName());
                configuration.messageInterpolator(configuration.getDefaultMessageInterpolator());
                ValidatorFactory factory = configuration.buildValidatorFactory();
                validator = factory.getValidator();
                // ** MonitorExit[var0] (shouldn't be in output)
                return validator;
            }
        }
        return validator;
    }

    public static <T> T tryValidate(T bean2, Class<?> ... group) {
        Set<ConstraintViolation<T>> violations = ValidatorUtils.getValidator().validate(bean2, group);
        if (!violations.isEmpty()) {
            throw new ValidationException(violations).withSource(bean2);
        }
        return bean2;
    }

    public static <T> T tryValidate(T bean2, String property, Class<?> ... group) {
        Set<ConstraintViolation<T>> violations = ValidatorUtils.getValidator().validateProperty(bean2, property, group);
        if (!violations.isEmpty()) {
            throw new ValidationException(violations).withSource(bean2);
        }
        return bean2;
    }

    public static <T> void tryValidate(Class<T> bean2, String property, Object value, Class<?> ... group) {
        Set<ConstraintViolation<T>> violations = ValidatorUtils.getValidator().validateValue(bean2, property, value, group);
        if (!violations.isEmpty()) {
            throw new ValidationException(violations).withSource(value);
        }
    }
}

