/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.core.message.codec;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import org.eclipse.californium.core.coap.CoAP;
import org.eclipse.californium.core.coap.Option;
import org.jetlinks.core.message.codec.CoapMessage;
import org.jetlinks.core.message.codec.TextMessageParser;

public class DefaultCoapMessage
implements CoapMessage {
    @Nonnull
    private String path;
    private CoAP.Code code;
    @Nonnull
    private ByteBuf payload;
    private List<Option> options;

    public String toString() {
        return this.print(true);
    }

    public static DefaultCoapMessage of(String coapString) {
        DefaultCoapMessage request = new DefaultCoapMessage();
        ArrayList<Option> options = new ArrayList<Option>();
        request.setOptions(options);
        TextMessageParser.of(start -> {
            String[] firstLine = start.split("[ ]");
            request.setCode(CoAP.Code.valueOf((String)firstLine[0]));
            request.setPath(firstLine[1]);
        }, (option, value) -> options.add(CoapMessage.parseOption(option, value)), body2 -> request.setPayload(Unpooled.wrappedBuffer(body2.getBody())), () -> request.setPayload(Unpooled.wrappedBuffer(new byte[0]))).parse(coapString);
        return request;
    }

    @Override
    @Nonnull
    public String getPath() {
        return this.path;
    }

    @Override
    public CoAP.Code getCode() {
        return this.code;
    }

    @Override
    @Nonnull
    public ByteBuf getPayload() {
        return this.payload;
    }

    public void setPath(@Nonnull String path2) {
        if (path2 == null) {
            throw new NullPointerException("path");
        }
        this.path = path2;
    }

    public void setCode(CoAP.Code code) {
        this.code = code;
    }

    public void setPayload(@Nonnull ByteBuf payload) {
        if (payload == null) {
            throw new NullPointerException("payload");
        }
        this.payload = payload;
    }

    public void setOptions(List<Option> options) {
        this.options = options;
    }

    public DefaultCoapMessage() {
    }

    public DefaultCoapMessage(@Nonnull String path2, CoAP.Code code, @Nonnull ByteBuf payload, List<Option> options) {
        if (path2 == null) {
            throw new NullPointerException("path");
        }
        if (payload == null) {
            throw new NullPointerException("payload");
        }
        this.path = path2;
        this.code = code;
        this.payload = payload;
        this.options = options;
    }

    @Override
    public List<Option> getOptions() {
        return this.options;
    }
}

