/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.core.codec.defaults;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.parser.Feature;
import com.alibaba.fastjson.serializer.SerializerFeature;
import javax.annotation.Nonnull;
import org.jetlinks.core.Payload;
import org.jetlinks.core.codec.Codec;
import org.jetlinks.core.metadata.Jsonable;

public class JsonCodec<T>
implements Codec<T> {
    private final Class<? extends T> type;

    private JsonCodec(Class<? extends T> type) {
        this.type = type;
    }

    public static <T> JsonCodec<T> of(Class<? extends T> type) {
        return new JsonCodec<T>(type);
    }

    @Override
    public Class<T> forType() {
        return this.type;
    }

    @Override
    public T decode(@Nonnull Payload payload) {
        return JSON.parseObject(payload.getBytes(false), this.type, new Feature[0]);
    }

    @Override
    public Payload encode(T body2) {
        if (body2 instanceof Jsonable) {
            return Payload.of(JSON.toJSONBytes((Object)((Jsonable)body2).toJson(), new SerializerFeature[0]));
        }
        return Payload.of(JSON.toJSONBytes(body2, new SerializerFeature[0]));
    }
}

