/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.core.cluster;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import org.jetlinks.core.cluster.ServerFeature;
import reactor.core.Disposable;

public class ServerFeatures {
    public static final Map<String, ServerFeature> features = new ConcurrentHashMap<String, ServerFeature>();

    public static Disposable addFeature(ServerFeature feature) {
        features.put(feature.getId(), feature);
        return () -> features.remove(feature.getId(), feature);
    }

    public static List<ServerFeature> features() {
        return new ArrayList<ServerFeature>(features.values());
    }

    public static Optional<ServerFeature> feature(String id) {
        return Optional.ofNullable(features.get(id));
    }
}

