/*
 * Decompiled with CFR 0.152.
 */
package com.github.freva.asciitable;

import com.github.freva.asciitable.AsciiTable;
import com.github.freva.asciitable.Column;
import com.github.freva.asciitable.ColumnData;
import com.github.freva.asciitable.Styler;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UncheckedIOException;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.IntStream;

public class AsciiTableBuilder {
    private String lineSeparator = System.lineSeparator();
    private Character[] border = AsciiTable.BASIC_ASCII;
    private Styler styler;
    private String[] header;
    private String[] footer;
    private Column[] columns;
    private Object[][] data;

    public AsciiTableBuilder lineSeparator(String lineSeparator) {
        this.lineSeparator = Objects.requireNonNull(lineSeparator, "line separator cannot be null");
        return this;
    }

    public AsciiTableBuilder border(Character[] border) {
        this.border = Objects.requireNonNull(border, "border cannot be null");
        return this;
    }

    public AsciiTableBuilder styler(Styler styler) {
        this.styler = Objects.requireNonNull(styler, "styler cannot be null");
        return this;
    }

    public AsciiTableBuilder header(String ... header) {
        this.header = header;
        return this;
    }

    public AsciiTableBuilder footer(String ... footer) {
        this.footer = footer;
        return this;
    }

    public AsciiTableBuilder data(Object[][] data) {
        this.data = data;
        return this;
    }

    public AsciiTableBuilder data(Column[] columns, Object[][] data) {
        this.columns = columns;
        this.data = data;
        return this;
    }

    public <T> AsciiTableBuilder data(Collection<T> objects, List<ColumnData<T>> columns) {
        Column[] rawColumns = columns.toArray(new Column[0]);
        Object[][] data = (String[][])objects.stream().map(object -> (String[])columns.stream().map(dataColumn -> dataColumn.getCellValue(object)).toArray(String[]::new)).toArray(x$0 -> new String[x$0][]);
        return this.data(rawColumns, data);
    }

    public String asString() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        this.writeTo(baos);
        return baos.toString();
    }

    public void writeTo(OutputStream os) {
        Column[] columns = this.columns;
        if (columns == null) {
            String[] nonNullHeader = this.header != null ? this.header : new String[]{};
            String[] nonNullFooter = this.footer != null ? this.footer : new String[]{};
            columns = (Column[])IntStream.range(0, Math.max(nonNullHeader.length, nonNullFooter.length)).mapToObj(index -> new Column().header(index < nonNullHeader.length ? nonNullHeader[index] : null).footer(index < nonNullFooter.length ? nonNullFooter[index] : null)).toArray(Column[]::new);
        } else if (this.header != null || this.footer != null) {
            throw new IllegalArgumentException("Cannot set both header/footer and columns");
        }
        try {
            OutputStreamWriter osw = new OutputStreamWriter(os);
            AsciiTable.writeTable(osw, this.lineSeparator, this.border, columns, this.data, this.styler);
            osw.flush();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public String toString() {
        return this.asString();
    }
}

