/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.reactive.result.method.annotation;

import java.util.Collections;
import java.util.Map;
import org.springframework.core.MethodParameter;
import org.springframework.core.ReactiveAdapterRegistry;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.reactive.BindingContext;
import org.springframework.web.reactive.HandlerMapping;
import org.springframework.web.reactive.result.method.HandlerMethodArgumentResolverSupport;
import org.springframework.web.reactive.result.method.SyncHandlerMethodArgumentResolver;
import org.springframework.web.server.ServerWebExchange;

public class PathVariableMapMethodArgumentResolver
extends HandlerMethodArgumentResolverSupport
implements SyncHandlerMethodArgumentResolver {
    public PathVariableMapMethodArgumentResolver(ReactiveAdapterRegistry adapterRegistry) {
        super(adapterRegistry);
    }

    @Override
    public boolean supportsParameter(MethodParameter parameter) {
        return this.checkAnnotatedParamNoReactiveWrapper(parameter, PathVariable.class, this::allVariables);
    }

    private boolean allVariables(PathVariable pathVariable, Class<?> type) {
        return Map.class.isAssignableFrom(type) && !StringUtils.hasText(pathVariable.value());
    }

    @Override
    public Object resolveArgumentValue(MethodParameter methodParameter, BindingContext context, ServerWebExchange exchange2) {
        String name = HandlerMapping.URI_TEMPLATE_VARIABLES_ATTRIBUTE;
        return exchange2.getAttributeOrDefault(name, Collections.emptyMap());
    }
}

