/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.core.message.property;

import com.alibaba.fastjson.JSONObject;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.jetlinks.core.message.CommonThingMessage;
import org.jetlinks.core.message.MessageType;
import org.jetlinks.core.message.property.ThingReportPropertyMessage;
import org.jetlinks.core.things.ThingProperty;

public class DefaultReportPropertyMessage
extends CommonThingMessage<DefaultReportPropertyMessage>
implements ThingReportPropertyMessage {
    private Map<String, Object> properties;
    private Map<String, Long> propertySourceTimes;
    private Map<String, String> propertyStates;

    public static DefaultReportPropertyMessage create() {
        return new DefaultReportPropertyMessage();
    }

    @Override
    public DefaultReportPropertyMessage success(Map<String, Object> properties) {
        this.properties = properties;
        return this;
    }

    @Override
    public DefaultReportPropertyMessage success(List<ThingProperty> properties) {
        this.properties = new LinkedHashMap<String, Object>();
        this.propertySourceTimes = new LinkedHashMap<String, Long>();
        this.propertyStates = new LinkedHashMap<String, String>();
        for (ThingProperty property : properties) {
            this.properties.put(property.getProperty(), property.getValue());
            this.propertySourceTimes.put(property.getProperty(), property.getTimestamp());
            this.propertyStates.put(property.getProperty(), property.getState());
        }
        return this;
    }

    @Override
    public DefaultReportPropertyMessage propertySourceTimes(Map<String, Long> times) {
        this.propertySourceTimes = times;
        return this;
    }

    @Override
    public DefaultReportPropertyMessage propertyStates(Map<String, String> states) {
        this.propertyStates = states;
        return this;
    }

    @Override
    public DefaultReportPropertyMessage properties(Map<String, Object> properties) {
        return this.success((Map)properties);
    }

    @Override
    public void fromJson(JSONObject jsonObject) {
        super.fromJson(jsonObject);
        this.properties = jsonObject.getJSONObject("properties");
        this.propertySourceTimes = jsonObject.getJSONObject("propertySourceTimes");
        this.propertyStates = jsonObject.getJSONObject("propertyStates");
    }

    @Override
    public MessageType getMessageType() {
        return MessageType.REPORT_PROPERTY;
    }

    @Override
    public Map<String, Object> getProperties() {
        return this.properties;
    }

    @Override
    public Map<String, Long> getPropertySourceTimes() {
        return this.propertySourceTimes;
    }

    @Override
    public Map<String, String> getPropertyStates() {
        return this.propertyStates;
    }

    public void setProperties(Map<String, Object> properties) {
        this.properties = properties;
    }

    public void setPropertySourceTimes(Map<String, Long> propertySourceTimes) {
        this.propertySourceTimes = propertySourceTimes;
    }

    public void setPropertyStates(Map<String, String> propertyStates) {
        this.propertyStates = propertyStates;
    }
}

