/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.core.message.codec;

import java.net.InetSocketAddress;
import java.time.Duration;
import java.util.Optional;
import javax.annotation.Nullable;
import org.jetlinks.core.device.DeviceOperator;
import org.jetlinks.core.message.codec.EncodedMessage;
import org.jetlinks.core.message.codec.Transport;
import org.jetlinks.core.server.session.DeviceSession;
import org.jetlinks.core.trace.DeviceTracer;
import org.jetlinks.core.trace.MonoTracer;
import reactor.core.publisher.Mono;

public class TraceDeviceSession
implements DeviceSession {
    private final DeviceSession target;

    @Override
    public String getId() {
        return this.target.getId();
    }

    @Override
    public String getDeviceId() {
        return this.target.getDeviceId();
    }

    @Override
    @Nullable
    public DeviceOperator getOperator() {
        return this.target.getOperator();
    }

    @Override
    public long lastPingTime() {
        return this.target.lastPingTime();
    }

    @Override
    public long connectTime() {
        return this.target.connectTime();
    }

    @Override
    public Mono<Boolean> send(EncodedMessage encodedMessage) {
        return (Mono)this.target.send(encodedMessage).as(MonoTracer.create(DeviceTracer.SpanName.downstream(this.getDeviceId()), builder -> builder.setAttribute(DeviceTracer.SpanKey.message, encodedMessage.toString())));
    }

    @Override
    public Transport getTransport() {
        return this.target.getTransport();
    }

    @Override
    public void close() {
        this.target.close();
    }

    @Override
    public void ping() {
        this.target.ping();
    }

    @Override
    public boolean isAlive() {
        return this.target.isAlive();
    }

    @Override
    public void onClose(Runnable call) {
        this.target.onClose(call);
    }

    @Override
    public Optional<InetSocketAddress> getClientAddress() {
        return this.target.getClientAddress();
    }

    @Override
    public <T extends DeviceSession> T unwrap(Class<T> type) {
        return this.target.unwrap(type);
    }

    @Override
    public boolean isWrapFrom(Class<?> type) {
        return this.target.isWrapFrom(type);
    }

    @Override
    public Optional<String> getServerId() {
        return this.target.getServerId();
    }

    @Override
    public Duration getKeepAliveTimeout() {
        return this.target.getKeepAliveTimeout();
    }

    @Override
    public Mono<Boolean> isAliveAsync() {
        return this.target.isAliveAsync();
    }

    private TraceDeviceSession(DeviceSession target) {
        this.target = target;
    }

    public static TraceDeviceSession of(DeviceSession target) {
        return new TraceDeviceSession(target);
    }
}

