/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.core.cluster;

import java.io.Serializable;
import java.util.Map;
import java.util.Optional;
import lombok.NonNull;
import org.hswebframework.web.bean.FastBeanCopier;

public class ServerNode
implements Serializable {
    private static final long serialVersionUID = -6849794470754667710L;
    @NonNull
    private String id;
    private String name;
    private String host;
    private Map<String, Object> tags;
    private boolean leader;
    private long uptime;
    private long lastKeepAlive;

    public boolean hasTag(String tag) {
        return this.tags != null && this.tags.containsKey(tag);
    }

    public Optional<Object> getTag(String tag) {
        return Optional.ofNullable(this.tags).map(t -> t.get(tag));
    }

    public boolean isSame(ServerNode another) {
        return this.id.equals(another.getId());
    }

    public ServerNode copy() {
        return FastBeanCopier.copy(this, new ServerNode(), new String[0]);
    }

    public static ServerNodeBuilder builder() {
        return new ServerNodeBuilder();
    }

    @NonNull
    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getHost() {
        return this.host;
    }

    public Map<String, Object> getTags() {
        return this.tags;
    }

    public boolean isLeader() {
        return this.leader;
    }

    public long getUptime() {
        return this.uptime;
    }

    public long getLastKeepAlive() {
        return this.lastKeepAlive;
    }

    public void setId(@NonNull String id) {
        if (id == null) {
            throw new NullPointerException("id");
        }
        this.id = id;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public void setTags(Map<String, Object> tags) {
        this.tags = tags;
    }

    public void setLeader(boolean leader) {
        this.leader = leader;
    }

    public void setUptime(long uptime) {
        this.uptime = uptime;
    }

    public void setLastKeepAlive(long lastKeepAlive) {
        this.lastKeepAlive = lastKeepAlive;
    }

    public ServerNode() {
    }

    public ServerNode(@NonNull String id, String name, String host, Map<String, Object> tags, boolean leader, long uptime, long lastKeepAlive) {
        if (id == null) {
            throw new NullPointerException("id");
        }
        this.id = id;
        this.name = name;
        this.host = host;
        this.tags = tags;
        this.leader = leader;
        this.uptime = uptime;
        this.lastKeepAlive = lastKeepAlive;
    }

    public static class ServerNodeBuilder {
        private String id;
        private String name;
        private String host;
        private Map<String, Object> tags;
        private boolean leader;
        private long uptime;
        private long lastKeepAlive;

        ServerNodeBuilder() {
        }

        public ServerNodeBuilder id(String id) {
            this.id = id;
            return this;
        }

        public ServerNodeBuilder name(String name) {
            this.name = name;
            return this;
        }

        public ServerNodeBuilder host(String host) {
            this.host = host;
            return this;
        }

        public ServerNodeBuilder tags(Map<String, Object> tags) {
            this.tags = tags;
            return this;
        }

        public ServerNodeBuilder leader(boolean leader) {
            this.leader = leader;
            return this;
        }

        public ServerNodeBuilder uptime(long uptime) {
            this.uptime = uptime;
            return this;
        }

        public ServerNodeBuilder lastKeepAlive(long lastKeepAlive) {
            this.lastKeepAlive = lastKeepAlive;
            return this;
        }

        public ServerNode build() {
            return new ServerNode(this.id, this.name, this.host, this.tags, this.leader, this.uptime, this.lastKeepAlive);
        }

        public String toString() {
            return "ServerNode.ServerNodeBuilder(id=" + this.id + ", name=" + this.name + ", host=" + this.host + ", tags=" + this.tags + ", leader=" + this.leader + ", uptime=" + this.uptime + ", lastKeepAlive=" + this.lastKeepAlive + ")";
        }
    }
}

