/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.core.message.codec;

import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.jetlinks.core.device.DeviceOperator;
import org.jetlinks.core.message.DeviceMessage;
import org.jetlinks.core.message.Message;
import org.jetlinks.core.message.codec.MessageCodecContext;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public interface MessageEncodeContext
extends MessageCodecContext {
    @Nonnull
    public Message getMessage();

    @Nonnull
    default public Mono<Void> reply(@Nonnull Publisher<? extends DeviceMessage> replyMessage) {
        return Mono.empty();
    }

    @Nonnull
    default public Mono<Void> reply(@Nonnull Collection<? extends DeviceMessage> messages) {
        return this.reply(Flux.fromIterable(messages));
    }

    @Nonnull
    default public Mono<Void> reply(DeviceMessage ... messages) {
        return this.reply(Flux.fromArray(messages));
    }

    default public MessageEncodeContext mutate(final Message anotherMessage, final DeviceOperator device) {
        return new MessageEncodeContext(){

            @Override
            public Map<String, Object> getConfiguration() {
                return MessageEncodeContext.this.getConfiguration();
            }

            @Override
            public Optional<Object> getConfig(String key) {
                return MessageEncodeContext.this.getConfig(key);
            }

            @Override
            @Nonnull
            public Message getMessage() {
                return anotherMessage;
            }

            @Override
            public Mono<DeviceOperator> getDevice(String deviceId) {
                return MessageEncodeContext.this.getDevice(deviceId);
            }

            @Override
            @Nullable
            public DeviceOperator getDevice() {
                return device;
            }

            @Override
            @Nonnull
            public Mono<Void> reply(DeviceMessage ... messages) {
                return MessageEncodeContext.this.reply(messages);
            }

            @Override
            @Nonnull
            public Mono<Void> reply(@Nonnull Collection<? extends DeviceMessage> messages) {
                return MessageEncodeContext.this.reply(messages);
            }

            @Override
            @Nonnull
            public Mono<Void> reply(@Nonnull Publisher<? extends DeviceMessage> replyMessage) {
                return MessageEncodeContext.this.reply(replyMessage);
            }
        };
    }
}

