/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.core.message;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import javax.annotation.Nullable;
import javax.validation.constraints.NotNull;
import org.jetlinks.core.enums.ErrorCode;
import org.jetlinks.core.message.HeaderKey;
import org.jetlinks.core.message.Message;
import org.jetlinks.core.message.ThingMessage;
import org.jetlinks.core.utils.SerializeUtils;

public interface ThingMessageReply
extends ThingMessage {
    public boolean isSuccess();

    @Nullable
    public String getCode();

    @Nullable
    public String getMessage();

    public ThingMessageReply error(ErrorCode var1);

    public ThingMessageReply error(Throwable var1);

    @Override
    public ThingMessageReply thingId(String var1, String var2);

    public ThingMessageReply success();

    public ThingMessageReply success(boolean var1);

    public ThingMessageReply code(@NotNull String var1);

    public ThingMessageReply message(@NotNull String var1);

    public ThingMessageReply from(@NotNull Message var1);

    @Override
    public ThingMessageReply messageId(@NotNull String var1);

    @Override
    public ThingMessageReply timestamp(@NotNull long var1);

    @Override
    public ThingMessageReply addHeader(@NotNull String var1, @NotNull Object var2);

    @Override
    default public <T> ThingMessageReply addHeader(@NotNull HeaderKey<T> header, @NotNull T value) {
        this.addHeader(header.getKey(), value);
        return this;
    }

    @Override
    default public ThingMessageReply copy() {
        return (ThingMessageReply)ThingMessage.super.copy();
    }

    @Override
    default public void writeExternal(ObjectOutput out) throws IOException {
        ThingMessage.super.writeExternal(out);
        out.writeBoolean(this.isSuccess());
        SerializeUtils.writeNullableUTF(this.getCode(), out);
        SerializeUtils.writeNullableUTF(this.getMessage(), out);
    }

    @Override
    default public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        ThingMessage.super.readExternal(in);
        this.success(in.readBoolean());
        this.code(SerializeUtils.readNullableUTF(in));
        this.message(SerializeUtils.readNullableUTF(in));
    }
}

