/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.core.things;

import java.util.HashMap;
import java.util.Map;
import org.jetlinks.core.config.ConfigKey;
import org.jetlinks.core.config.ConfigKeyValue;

public class ThingInfo {
    private String id;
    private String templateId;
    private String name;
    private String metadata;
    private Long version;
    private Map<String, Object> configuration;

    public ThingInfo addConfig(String key, Object value) {
        if (this.configuration == null) {
            this.configuration = new HashMap<String, Object>();
        }
        this.configuration.put(key, value);
        return this;
    }

    public ThingInfo addConfigIfAbsent(String key, Object value) {
        if (this.configuration == null) {
            this.configuration = new HashMap<String, Object>();
        }
        this.configuration.putIfAbsent(key, value);
        return this;
    }

    public ThingInfo addConfigs(Map<String, ?> configs) {
        if (configs == null) {
            return this;
        }
        configs.forEach(this::addConfig);
        return this;
    }

    public <T> ThingInfo addConfig(ConfigKey<T> key, T value) {
        this.addConfig(key.getKey(), value);
        return this;
    }

    public <T> ThingInfo addConfig(ConfigKeyValue<T> keyValue) {
        this.addConfig(keyValue.getKey(), keyValue.getValue());
        return this;
    }

    ThingInfo(String id, String templateId, String name, String metadata, Long version, Map<String, Object> configuration) {
        this.id = id;
        this.templateId = templateId;
        this.name = name;
        this.metadata = metadata;
        this.version = version;
        this.configuration = configuration;
    }

    public static ThingInfoBuilder builder() {
        return new ThingInfoBuilder();
    }

    public String getId() {
        return this.id;
    }

    public String getTemplateId() {
        return this.templateId;
    }

    public String getName() {
        return this.name;
    }

    public String getMetadata() {
        return this.metadata;
    }

    public Long getVersion() {
        return this.version;
    }

    public Map<String, Object> getConfiguration() {
        return this.configuration;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setTemplateId(String templateId) {
        this.templateId = templateId;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setMetadata(String metadata) {
        this.metadata = metadata;
    }

    public void setVersion(Long version) {
        this.version = version;
    }

    public void setConfiguration(Map<String, Object> configuration) {
        this.configuration = configuration;
    }

    public static class ThingInfoBuilder {
        private String id;
        private String templateId;
        private String name;
        private String metadata;
        private Long version;
        private Map<String, Object> configuration;

        ThingInfoBuilder() {
        }

        public ThingInfoBuilder id(String id) {
            this.id = id;
            return this;
        }

        public ThingInfoBuilder templateId(String templateId) {
            this.templateId = templateId;
            return this;
        }

        public ThingInfoBuilder name(String name) {
            this.name = name;
            return this;
        }

        public ThingInfoBuilder metadata(String metadata) {
            this.metadata = metadata;
            return this;
        }

        public ThingInfoBuilder version(Long version) {
            this.version = version;
            return this;
        }

        public ThingInfoBuilder configuration(Map<String, Object> configuration) {
            this.configuration = configuration;
            return this;
        }

        public ThingInfo build() {
            return new ThingInfo(this.id, this.templateId, this.name, this.metadata, this.version, this.configuration);
        }

        public String toString() {
            return "ThingInfo.ThingInfoBuilder(id=" + this.id + ", templateId=" + this.templateId + ", name=" + this.name + ", metadata=" + this.metadata + ", version=" + this.version + ", configuration=" + this.configuration + ")";
        }
    }
}

