/*
 * Decompiled with CFR 0.152.
 */
package reactor.netty.http.brave;

import brave.propagation.CurrentTraceContext;
import io.netty.channel.Channel;
import java.net.SocketAddress;
import reactor.netty.ChannelPipelineConfigurer;
import reactor.netty.Connection;
import reactor.netty.ConnectionObserver;
import reactor.netty.http.brave.TracingChannelInboundHandler;
import reactor.netty.http.brave.TracingChannelOutboundHandler;
import reactor.util.annotation.Nullable;

final class TracingChannelPipelineConfigurer
implements ChannelPipelineConfigurer {
    final TracingChannelInboundHandler inboundHandler;
    final TracingChannelOutboundHandler outboundHandler;

    TracingChannelPipelineConfigurer(CurrentTraceContext currentTraceContext) {
        this.inboundHandler = new TracingChannelInboundHandler(currentTraceContext);
        this.outboundHandler = new TracingChannelOutboundHandler(currentTraceContext);
    }

    @Override
    public void onChannelInit(ConnectionObserver connectionObserver, Channel channel, @Nullable SocketAddress socketAddress) {
        Connection.from(channel).addHandlerFirst("reactor.left.tracingChannelInboundHandler", this.inboundHandler).addHandlerLast("reactor.right.tracingChannelOutboundHandler", this.outboundHandler);
    }
}

