/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.core.things;

import java.nio.charset.StandardCharsets;
import lombok.NonNull;
import org.springframework.util.DigestUtils;

public class ThingId {
    @NonNull
    private final String type;
    @NonNull
    private final String id;

    public String toUniqueId() {
        byte[] typeBytes = this.type.getBytes(StandardCharsets.UTF_8);
        byte[] idBytes = this.id.getBytes(StandardCharsets.UTF_8);
        byte[] arr = new byte[typeBytes.length + idBytes.length];
        System.arraycopy(typeBytes, 0, arr, 0, typeBytes.length);
        System.arraycopy(idBytes, 0, arr, typeBytes.length, idBytes.length);
        return DigestUtils.md5DigestAsHex(arr);
    }

    public String toString() {
        return this.type + ":" + this.id;
    }

    @NonNull
    public String getType() {
        return this.type;
    }

    @NonNull
    public String getId() {
        return this.id;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ThingId)) {
            return false;
        }
        ThingId other = (ThingId)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$type = this.getType();
        String other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        return !(this$id == null ? other$id != null : !this$id.equals(other$id));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ThingId;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        return result;
    }

    private ThingId(@NonNull String type, @NonNull String id) {
        if (type == null) {
            throw new NullPointerException("type");
        }
        if (id == null) {
            throw new NullPointerException("id");
        }
        this.type = type;
        this.id = id;
    }

    public static ThingId of(@NonNull String type, @NonNull String id) {
        return new ThingId(type, id);
    }
}

