/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.core.codec;

import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.ServiceLoader;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.annotation.Nonnull;
import org.jetlinks.core.cache.Caches;
import org.jetlinks.core.codec.Codec;
import org.jetlinks.core.codec.CodecsSupport;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.ResolvableType;

public final class Codecs {
    private static final Logger log = LoggerFactory.getLogger(Codecs.class);
    private static Map<ResolvableType, Codec<?>> mapping = Caches.newCache();
    private static List<CodecsSupport> allCodec = new CopyOnWriteArrayList<CodecsSupport>();

    public static final void register(CodecsSupport support) {
        allCodec.add(support);
        allCodec.sort(Comparator.comparingInt(CodecsSupport::getOrder));
    }

    @Nonnull
    private static Codec<?> resolve(ResolvableType target) {
        for (CodecsSupport support : allCodec) {
            Optional lookup = support.lookup(target);
            if (!lookup.isPresent()) continue;
            log.debug("lookup codec [{}] for [{}]", (Object)lookup.get(), (Object)target);
            return lookup.get();
        }
        throw new UnsupportedOperationException("unsupported codec for " + target);
    }

    public static <T> Codec<T> lookup(@Nonnull Class<? extends T> target) {
        return Codecs.lookup(ResolvableType.forType(target));
    }

    public static <T> Codec<T> lookup(ResolvableType type) {
        if (Publisher.class.isAssignableFrom(type.toClass())) {
            type = type.getGeneric(0);
        }
        return mapping.computeIfAbsent(type, Codecs::resolve);
    }

    static {
        ServiceLoader.load(CodecsSupport.class).forEach(allCodec::add);
        allCodec.sort(Comparator.comparingInt(CodecsSupport::getOrder));
    }
}

