/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.core.message.property;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.List;
import org.jetlinks.core.message.MessageType;
import org.jetlinks.core.message.RepayableThingMessage;
import org.jetlinks.core.message.property.DefaultReadPropertyMessage;
import org.jetlinks.core.message.property.ReadPropertyMessage;
import org.jetlinks.core.message.property.ReadThingPropertyMessageReply;
import org.jetlinks.core.things.ThingType;

public interface ReadThingPropertyMessage<T extends ReadThingPropertyMessageReply>
extends RepayableThingMessage<T> {
    public List<String> getProperties();

    public ReadThingPropertyMessage<T> addProperties(List<String> var1);

    @Override
    default public MessageType getMessageType() {
        return MessageType.READ_PROPERTY;
    }

    public static ReadPropertyMessage forDevice(String deviceId) {
        ReadPropertyMessage message = new ReadPropertyMessage();
        message.setDeviceId(deviceId);
        return message;
    }

    public static DefaultReadPropertyMessage forThing(ThingType thingType, String deviceId) {
        DefaultReadPropertyMessage message = new DefaultReadPropertyMessage();
        message.setThingId(deviceId);
        message.setThingType(thingType.getId());
        return message;
    }

    @Override
    default public void writeExternal(ObjectOutput out) throws IOException {
        RepayableThingMessage.super.writeExternal(out);
        List<String> properties = this.getProperties();
        if (properties == null) {
            out.writeInt(0);
        } else {
            out.writeInt(properties.size());
            for (String property : properties) {
                out.writeUTF(property);
            }
        }
    }

    @Override
    default public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        RepayableThingMessage.super.readExternal(in);
        int size = in.readInt();
        if (size > 0) {
            ArrayList<String> properties = new ArrayList<String>(size);
            for (int i2 = 0; i2 < size; ++i2) {
                properties.add(in.readUTF());
            }
            this.addProperties(properties);
        }
    }
}

