/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.reactive.resource;

import java.util.List;
import org.springframework.core.io.Resource;
import org.springframework.lang.Nullable;
import org.springframework.web.reactive.resource.AbstractResourceResolver;
import org.springframework.web.reactive.resource.ResourceResolverChain;
import org.springframework.web.server.ServerWebExchange;
import org.webjars.WebJarAssetLocator;
import reactor.core.publisher.Mono;

public class WebJarsResourceResolver
extends AbstractResourceResolver {
    private static final String WEBJARS_LOCATION = "META-INF/resources/webjars/";
    private static final int WEBJARS_LOCATION_LENGTH = "META-INF/resources/webjars/".length();
    private final WebJarAssetLocator webJarAssetLocator;

    public WebJarsResourceResolver() {
        this(new WebJarAssetLocator());
    }

    public WebJarsResourceResolver(WebJarAssetLocator webJarAssetLocator) {
        this.webJarAssetLocator = webJarAssetLocator;
    }

    @Override
    protected Mono<Resource> resolveResourceInternal(@Nullable ServerWebExchange exchange2, String requestPath, List<? extends Resource> locations, ResourceResolverChain chain) {
        return chain.resolveResource(exchange2, requestPath, locations).switchIfEmpty(Mono.defer(() -> {
            String webJarsResourcePath = this.findWebJarResourcePath(requestPath);
            if (webJarsResourcePath != null) {
                return chain.resolveResource(exchange2, webJarsResourcePath, locations);
            }
            return Mono.empty();
        }));
    }

    @Override
    protected Mono<String> resolveUrlPathInternal(String resourceUrlPath, List<? extends Resource> locations, ResourceResolverChain chain) {
        return chain.resolveUrlPath(resourceUrlPath, locations).switchIfEmpty(Mono.defer(() -> {
            String webJarResourcePath = this.findWebJarResourcePath(resourceUrlPath);
            if (webJarResourcePath != null) {
                return chain.resolveUrlPath(webJarResourcePath, locations);
            }
            return Mono.empty();
        }));
    }

    @Nullable
    protected String findWebJarResourcePath(String path2) {
        String partialPath;
        String webjar;
        String webJarPath;
        int startOffset = path2.startsWith("/") ? 1 : 0;
        int endOffset = path2.indexOf(47, 1);
        if (endOffset != -1 && (webJarPath = this.webJarAssetLocator.getFullPathExact(webjar = path2.substring(startOffset, endOffset), partialPath = path2.substring(endOffset + 1))) != null) {
            return webJarPath.substring(WEBJARS_LOCATION_LENGTH);
        }
        return null;
    }
}

