/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.simulator.cmd.tcp;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import io.vertx.core.buffer.Buffer;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.ArrayList;
import org.jetlinks.simulator.cmd.CommonCommand;
import org.jetlinks.simulator.cmd.ConnectionAttachCommand;
import org.jetlinks.simulator.cmd.tcp.TcpSendCommand;
import org.jetlinks.simulator.core.ExceptionUtils;
import org.jetlinks.simulator.core.network.tcp.TcpClient;
import org.jline.utils.AttributedString;
import org.joda.time.DateTime;
import picocli.CommandLine;
import reactor.core.Disposable;

@CommandLine.Command(name="attach", description={"attach TCP connection"})
public class TcpAttachCommand
extends ConnectionAttachCommand {
    @Override
    @CommandLine.Parameters(paramLabel="id", completionCandidates=TcpSendCommand.IdComplete.class)
    public void setId(String id) {
        super.setId(id);
    }

    @Override
    protected void doInit() {
        this.disposable.add(this.connection.unwrap(TcpClient.class).handlePayload(this::appendMessage));
    }

    private void appendMessage(Buffer buffer) {
        ArrayList<AttributedString> msgLine = new ArrayList<AttributedString>();
        ByteBuf byteBuf = buffer.getByteBuf();
        String str = ByteBufUtil.isText(byteBuf, StandardCharsets.UTF_8) ? byteBuf.toString(StandardCharsets.UTF_8) : ByteBufUtil.prettyHexDump(byteBuf);
        msgLine.add(TcpAttachCommand.createLine(builder -> builder.append(new DateTime().toString("HH:mm:ss"), red)));
        for (String n : str.split("\n")) {
            msgLine.add(TcpAttachCommand.createLine(builder -> builder.append(n, green)));
        }
        this.messages.add(msgLine);
        if (this.messages.size() > 5) {
            this.messages.removeFirst();
        }
    }

    @Override
    protected AttachCommands createCommand() {
        return new AttachCommands();
    }

    @CommandLine.Command(name="disconnect", description={"Disconnect TCP"})
    static class Disconnect
    extends CommonCommand {
        Disconnect() {
        }

        @Override
        public void run() {
            ((AttachCommands)this.getParent()).disconnect();
        }
    }

    @CommandLine.Command(name="send", description={"Send TCP packet"})
    static class Send
    extends CommonCommand {
        @CommandLine.Parameters(arity="1", description={"0x\u5f00\u5934\u4e3a16\u8fdb\u5236"})
        String payload;

        Send() {
        }

        @Override
        public void run() {
            ((AttachCommands)this.getParent()).send(this);
        }
    }

    @CommandLine.Command(name="", subcommands={Send.class, Disconnect.class}, customSynopsis={""}, synopsisHeading="")
    class AttachCommands
    extends CommonCommand {
        AttachCommands() {
        }

        void send(Send send) {
            TcpClient client = TcpAttachCommand.this.connection.unwrap(TcpClient.class);
            try {
                this.printf("sending ", new Object[0]);
                client.sendAsync(send.payload).block(Duration.ofSeconds(10L));
                this.printf("success!%n", new Object[0]);
            }
            catch (Throwable e) {
                this.printfError("error:%s%n", ExceptionUtils.getErrorMessage(e));
            }
        }

        void disconnect() {
            this.main().connectionManager().getConnectionNow(TcpAttachCommand.this.getId()).ifPresent(Disposable::dispose);
        }
    }
}

