/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.simulator.cli;

import java.io.PrintWriter;
import org.jline.reader.LineReader;
import org.jline.terminal.Terminal;
import picocli.CommandLine;

public class JLineInteractiveCommands {
    private PrintWriter out;
    private CommandLine commandLine;
    private Terminal terminal;

    void setConsole(LineReader reader) {
        this.out = new PrintWriter(reader.getTerminal().writer());
    }

    void setCommandLine(CommandLine commandLine) {
        this.commandLine = commandLine;
    }

    void setTerminal(Terminal terminal) {
        this.terminal = terminal;
    }

    public PrintWriter getConsoleWriter() {
        return this.out;
    }

    public Terminal getTerminal() {
        return this.terminal;
    }

    public CommandLine getCommandLine() {
        return this.commandLine;
    }

    public void printUsageMessage() {
        this.out.print(this.commandLine.getUsageMessage());
        this.out.flush();
    }

    public PrintWriter printf(String format, Object ... args) {
        return this.out.printf(format, args);
    }

    public PrintWriter printfAnsi(String format, Object ... args) {
        return this.out.printf(this.commandLine.getColorScheme().ansi().string(format), args);
    }

    public PrintWriter printfError(String string, Object ... args) {
        this.out.printf(this.commandLine.getColorScheme().errorText(string).toString(), args);
        return this.out;
    }

    public void flush() {
        this.out.flush();
    }
}

