/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.reactor.ql.supports.map;

import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.sf.jsqlparser.expression.Expression;
import org.jetlinks.reactor.ql.ReactorQLMetadata;
import org.jetlinks.reactor.ql.ReactorQLRecord;
import org.jetlinks.reactor.ql.feature.FeatureId;
import org.jetlinks.reactor.ql.feature.ValueMapFeature;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;

public class FunctionMapFeature
implements ValueMapFeature {
    int maxParamSize;
    int minParamSize;
    public Function<Flux<Object>, Publisher<?>> mapper;
    private final String id;

    public FunctionMapFeature(String function, int max, int min2, Function<Flux<Object>, Publisher<?>> mapper) {
        this.maxParamSize = max;
        this.minParamSize = min2;
        this.mapper = mapper;
        this.id = FeatureId.ValueMap.of(function).getId();
    }

    @Override
    public Function<ReactorQLRecord, Publisher<?>> createMapper(Expression expression, ReactorQLMetadata metadata) {
        net.sf.jsqlparser.expression.Function function = (net.sf.jsqlparser.expression.Function)expression;
        if (function.getParameters() == null && this.minParamSize != 0) {
            throw new UnsupportedOperationException("\u51fd\u6570[" + expression + "]\u5fc5\u987b\u4f20\u5165\u53c2\u6570");
        }
        if (function.getParameters() == null) {
            return v -> this.mapper.apply(Flux.empty());
        }
        List<Expression> parameters = function.getParameters().getExpressions();
        if (parameters.size() > this.maxParamSize || parameters.size() < this.minParamSize) {
            throw new UnsupportedOperationException("\u51fd\u6570[" + expression + "]\u53c2\u6570\u6570\u91cf\u9519\u8bef");
        }
        List mappers = parameters.stream().map(expr -> ValueMapFeature.createMapperNow(expr, metadata)).collect(Collectors.toList());
        return v -> this.mapper.apply(Flux.fromIterable(mappers).flatMap(mp -> (Publisher)mp.apply(v)));
    }

    @Override
    public String getId() {
        return this.id;
    }
}

