/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.core.server.session;

import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import org.jetlinks.core.server.session.DeviceSessionProvider;
import org.jetlinks.core.server.session.KeepOnlineDeviceSessionProvider;

public class DeviceSessionProviders {
    public static final Map<String, DeviceSessionProvider> providers = new ConcurrentHashMap<String, DeviceSessionProvider>();

    public static void register(DeviceSessionProvider provider) {
        providers.put(provider.getId(), provider);
    }

    public static Optional<DeviceSessionProvider> lookup(String id) {
        return Optional.ofNullable(providers.get(id));
    }

    static {
        KeepOnlineDeviceSessionProvider.load();
    }
}

