/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.utils.file;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Serializable;
import java.io.Writer;
import org.hswebframework.utils.StringUtils;
import org.hswebframework.utils.file.EncodingDetect;
import org.hswebframework.utils.file.Resources;
import org.hswebframework.utils.file.callback.ReadCallBack;
import org.hswebframework.utils.file.callback.ReadStringCallBack;
import org.hswebframework.utils.file.callback.ScanCallBack;

public class FileUtils
extends Resources {
    public static void scanFile(String path2, int maxDeep, ScanCallBack callBack) {
        FileUtils.scanFile(path2, true, maxDeep, 0, callBack);
    }

    public static void scanFile(String path2, boolean depth, ScanCallBack callBack) {
        FileUtils.scanFile(path2, depth, -1, 0, callBack);
    }

    public static void scanFile(String path2, ScanCallBack callBack) {
        FileUtils.scanFile(path2, false, callBack);
    }

    private static void scanFile(String path2, boolean depth, int maxDeep, int deep, ScanCallBack callBack) {
        if (maxDeep != -1 && deep > maxDeep || callBack.isExit()) {
            return;
        }
        File file = new File(path2);
        try {
            if (file.isFile()) {
                callBack.accept(deep, file);
            } else {
                File[] files;
                callBack.accept(++deep, file);
                for (File file2 : files = file.listFiles()) {
                    if (callBack.isExit()) {
                        return;
                    }
                    if (depth) {
                        FileUtils.scanFile(file2.getAbsolutePath(), depth, maxDeep, deep, callBack);
                        continue;
                    }
                    if (file2.isFile()) {
                        callBack.accept(deep, file2);
                        continue;
                    }
                    if (!file2.isDirectory()) continue;
                    callBack.accept(deep, file2);
                }
            }
        }
        catch (Throwable e) {
            callBack.error(deep, file, e);
        }
    }

    public static final String getFileEncode(String fileName) {
        String encode = EncodingDetect.getJavaEncode(fileName);
        if (StringUtils.isNullOrEmpty(encode)) {
            encode = "utf8";
        }
        return encode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void readFile(Reader reader, ReadCallBack callBack) throws IOException {
        int number = 0;
        try (BufferedReader bufferedReader = new BufferedReader(reader);){
            while (bufferedReader.ready()) {
                if (callBack.isExit()) {
                    break;
                }
                callBack.readLine(number++, bufferedReader.readLine());
            }
        }
        callBack.done(number);
    }

    public static final String reader2String(String fileName) throws IOException {
        Reader reader;
        ReadStringCallBack callBack = new ReadStringCallBack();
        try {
            reader = FileUtils.getResourceAsReader(fileName);
        }
        catch (Exception e) {
            reader = new InputStreamReader(new FileInputStream(fileName));
        }
        FileUtils.readFile(reader, callBack);
        return callBack.toString();
    }

    public static final void readerFile(String fileName, ReadCallBack callBack) throws Exception {
        FileUtils.readFile(FileUtils.getResourceAsReader(fileName), callBack);
    }

    public static final String reader2String(Reader reader) throws Exception {
        ReadStringCallBack callBack = new ReadStringCallBack();
        FileUtils.readFile(reader, callBack);
        return callBack.toString();
    }

    public static final <T> T readFile2Obj(String fileName) throws Exception {
        try (FileInputStream input = new FileInputStream(fileName);){
            T t = FileUtils.readStream2Obj(input);
            return t;
        }
    }

    public static final <T> T readStream2Obj(InputStream inputStream) throws Exception {
        try (ObjectInputStream stream = null;){
            stream = new ObjectInputStream(inputStream);
            Object object = stream.readObject();
            return (T)object;
        }
    }

    public static final void writeObj2File(Serializable obj, String fileName) throws Exception {
        try (FileOutputStream out = new FileOutputStream(fileName);){
            FileUtils.writeObj2Steam(obj, out);
        }
    }

    public static final void writeString2File(String str, String fileName, String encode) throws Exception {
        File file = new File(fileName);
        if (!file.getParentFile().exists()) {
            file.getParentFile().mkdirs();
        }
        try (OutputStreamWriter out = new OutputStreamWriter((OutputStream)new FileOutputStream(fileName), encode);){
            out.write(str);
            ((Writer)out).flush();
        }
    }

    public static final void writeObj2Steam(Serializable obj, OutputStream outputStream) throws Exception {
        ObjectOutputStream stream = new ObjectOutputStream(outputStream);
        stream.writeObject(obj);
        stream.flush();
    }

    public static String getSuffix(File file) {
        return FileUtils.getSuffix(file.getName());
    }

    public static String getSuffix(String fileName) {
        if (fileName == null) {
            return "";
        }
        if (fileName.contains(".")) {
            return fileName.substring(fileName.lastIndexOf(".") + 1, fileName.length());
        }
        return "";
    }
}

