/*
 * Decompiled with CFR 0.152.
 */
package com.github.freva.asciitable;

import com.github.freva.asciitable.ColumnData;
import com.github.freva.asciitable.HorizontalAlign;
import com.github.freva.asciitable.OverflowBehaviour;
import java.util.function.Function;

public class Column {
    private String header;
    private String footer;
    private HorizontalAlign headerAlign;
    private HorizontalAlign dataAlign;
    private HorizontalAlign footerAlign;
    private int minWidth;
    private int maxWidth;
    private OverflowBehaviour overflowBehaviour;
    private boolean visible;

    public Column() {
        this(null, null, HorizontalAlign.LEFT, HorizontalAlign.RIGHT, HorizontalAlign.LEFT, 0, 80, OverflowBehaviour.NEWLINE, true);
    }

    @Deprecated
    public Column(String header, String footer, HorizontalAlign headerAlign, HorizontalAlign dataAlign, HorizontalAlign footerAlign, int maxWidth) {
        this(header, footer, headerAlign, dataAlign, footerAlign, 0, maxWidth, OverflowBehaviour.NEWLINE, true);
    }

    Column(String header, String footer, HorizontalAlign headerAlign, HorizontalAlign dataAlign, HorizontalAlign footerAlign, int minWidth, int maxWidth, OverflowBehaviour overflowBehaviour, boolean visible) {
        this.header = header;
        this.footer = footer;
        this.headerAlign = headerAlign;
        this.dataAlign = dataAlign;
        this.footerAlign = footerAlign;
        this.minWidth = minWidth;
        this.maxWidth = maxWidth;
        this.overflowBehaviour = overflowBehaviour;
        this.visible = visible;
    }

    public String getHeader() {
        return this.header;
    }

    public String getFooter() {
        return this.footer;
    }

    public HorizontalAlign getHeaderAlign() {
        return this.headerAlign;
    }

    public HorizontalAlign getDataAlign() {
        return this.dataAlign;
    }

    public HorizontalAlign getFooterAlign() {
        return this.footerAlign;
    }

    public int getMinWidth() {
        return this.minWidth;
    }

    public int getMaxWidth() {
        return this.maxWidth;
    }

    @Deprecated
    public int getMaxColumnWidth() {
        return this.maxWidth;
    }

    public OverflowBehaviour getOverflowBehaviour() {
        return this.overflowBehaviour;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public Column header(String header) {
        this.header = header;
        return this;
    }

    public Column footer(String footer) {
        this.footer = footer;
        return this;
    }

    public Column headerAlign(HorizontalAlign headerAlign) {
        this.headerAlign = headerAlign;
        return this;
    }

    public Column dataAlign(HorizontalAlign dataAlign) {
        this.dataAlign = dataAlign;
        return this;
    }

    public Column footerAlign(HorizontalAlign footerAlign) {
        this.footerAlign = footerAlign;
        return this;
    }

    public Column minWidth(int minWidth) {
        this.minWidth = minWidth;
        return this;
    }

    public Column maxWidth(int maxWidth) {
        return this.maxWidth(maxWidth, OverflowBehaviour.NEWLINE);
    }

    public Column maxWidth(int maxWidth, OverflowBehaviour overflowBehaviour) {
        this.maxWidth = maxWidth;
        this.overflowBehaviour = overflowBehaviour;
        return this;
    }

    @Deprecated
    public Column maxColumnWidth(int maxWidth) {
        return this.maxWidth(maxWidth);
    }

    public Column visible(boolean visible) {
        this.visible = visible;
        return this;
    }

    public <T> ColumnData<T> with(Function<T, String> getter) {
        return new ColumnData<T>(this, getter);
    }
}

