/*
 * Decompiled with CFR 0.152.
 */
package brave.http;

import brave.http.HttpAdapter;
import brave.http.HttpRequest;
import brave.http.HttpRequestMatchers;
import brave.http.HttpSampler;
import brave.internal.Nullable;
import brave.sampler.CountingSampler;
import brave.sampler.Matcher;
import brave.sampler.Matchers;
import brave.sampler.ParameterizedSampler;
import brave.sampler.RateLimitingSampler;
import brave.sampler.Sampler;
import brave.sampler.SamplerFunction;

public final class HttpRuleSampler
extends HttpSampler
implements SamplerFunction<HttpRequest> {
    final ParameterizedSampler<HttpRequest> delegate;

    public static Builder newBuilder() {
        return new Builder();
    }

    HttpRuleSampler(ParameterizedSampler<HttpRequest> delegate) {
        this.delegate = delegate;
    }

    @Override
    public Boolean trySample(HttpRequest request) {
        return this.delegate.trySample(request);
    }

    @Override
    @Deprecated
    public <Req> Boolean trySample(HttpAdapter<Req, ?> adapter, Req request) {
        if (request == null) {
            return null;
        }
        return this.trySample(new HttpSampler.FromHttpAdapter<Req>(adapter, request));
    }

    public static final class Builder {
        final ParameterizedSampler.Builder<HttpRequest> delegate = ParameterizedSampler.newBuilder();

        @Deprecated
        public Builder addRule(@Nullable String method2, String path2, float probability) {
            if (path2 == null) {
                throw new NullPointerException("path == null");
            }
            Sampler sampler = CountingSampler.create(probability);
            if (method2 == null) {
                this.delegate.putRule(HttpRequestMatchers.pathStartsWith(path2), RateLimitingSampler.create(10));
                return this;
            }
            this.delegate.putRule(Matchers.and(HttpRequestMatchers.methodEquals(method2), HttpRequestMatchers.pathStartsWith(path2)), sampler);
            return this;
        }

        public Builder putAllRules(HttpRuleSampler sampler) {
            if (sampler == null) {
                throw new NullPointerException("sampler == null");
            }
            this.delegate.putAllRules(sampler.delegate);
            return this;
        }

        public Builder putRule(Matcher<HttpRequest> matcher, Sampler sampler) {
            this.delegate.putRule(matcher, sampler);
            return this;
        }

        public HttpRuleSampler build() {
            return new HttpRuleSampler(this.delegate.build());
        }

        Builder() {
        }
    }
}

