/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.demo.protocol.websocket;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.nio.charset.StandardCharsets;
import org.jetlinks.core.message.DeviceMessage;
import org.jetlinks.core.message.DisconnectDeviceMessage;
import org.jetlinks.core.message.Message;
import org.jetlinks.core.message.codec.DefaultTransport;
import org.jetlinks.core.message.codec.DeviceMessageCodec;
import org.jetlinks.core.message.codec.EncodedMessage;
import org.jetlinks.core.message.codec.MessageDecodeContext;
import org.jetlinks.core.message.codec.MessageEncodeContext;
import org.jetlinks.core.message.codec.ToDeviceMessageContext;
import org.jetlinks.core.message.codec.Transport;
import org.jetlinks.core.message.codec.http.websocket.DefaultWebSocketMessage;
import org.jetlinks.core.message.codec.http.websocket.WebSocketMessage;
import org.jetlinks.core.message.codec.http.websocket.WebSocketSession;
import org.jetlinks.core.message.codec.http.websocket.WebSocketSessionMessage;
import org.jetlinks.demo.protocol.TopicMessage;
import org.jetlinks.demo.protocol.TopicMessageCodec;
import reactor.core.publisher.Mono;

public class WebsocketDeviceMessageCodec
extends TopicMessageCodec
implements DeviceMessageCodec {
    public Transport getSupportTransport() {
        return DefaultTransport.WebSocket;
    }

    public Mono<? extends Message> decode(MessageDecodeContext context) {
        return Mono.defer(() -> {
            WebSocketSessionMessage mqttMessage = (WebSocketSessionMessage)context.getMessage();
            WebSocketSession session = mqttMessage.getWebSocketSession();
            JSONObject payload = JSON.parseObject((String)mqttMessage.getPayload().toString(StandardCharsets.UTF_8));
            return Mono.justOrEmpty((Object)this.doDecode(null, session.getUri(), payload)).switchIfEmpty(Mono.defer(() -> session.send(session.textMessage("{\"status\":404}")).then(Mono.empty())));
        });
    }

    public Mono<EncodedMessage> encode(MessageEncodeContext context) {
        Message message = context.getMessage();
        return Mono.defer(() -> {
            if (message instanceof DeviceMessage) {
                if (message instanceof DisconnectDeviceMessage) {
                    return ((ToDeviceMessageContext)context).disconnect().then(Mono.empty());
                }
                TopicMessage msg = this.doEncode((DeviceMessage)message);
                if (null == msg) {
                    return Mono.empty();
                }
                JSONObject data = new JSONObject();
                data.put("topic", (Object)msg.getTopic());
                data.put("message", msg.getMessage());
                return Mono.just((Object)DefaultWebSocketMessage.of((WebSocketMessage.Type)WebSocketMessage.Type.TEXT, (ByteBuf)Unpooled.wrappedBuffer((byte[])data.toJSONString().getBytes())));
            }
            return Mono.empty();
        });
    }
}

