/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.core.server.mqtt;

import io.netty.buffer.ByteBuf;
import javax.annotation.Nonnull;
import org.jetlinks.core.message.codec.MqttMessage;
import org.jetlinks.core.server.mqtt.MqttPublishingMessage;

class ProxyMqttPublishingMessage
implements MqttPublishingMessage {
    private final MqttMessage target;
    private final Runnable ack;

    @Override
    @Nonnull
    public ByteBuf getPayload() {
        return this.target.getPayload();
    }

    @Override
    @Nonnull
    public String getTopic() {
        return this.target.getTopic();
    }

    @Override
    public String getClientId() {
        return this.target.getClientId();
    }

    @Override
    public int getMessageId() {
        return this.target.getMessageId();
    }

    @Override
    public void acknowledge() {
        this.ack.run();
        if (this.target instanceof MqttPublishingMessage) {
            ((MqttPublishingMessage)this.target).acknowledge();
        }
    }

    @Override
    public int getQosLevel() {
        return this.target.getQosLevel();
    }

    @Override
    public boolean isDup() {
        return this.target.isDup();
    }

    @Override
    public boolean isRetain() {
        return this.target.isRetain();
    }

    @Override
    public boolean isWill() {
        return this.target.isWill();
    }

    private ProxyMqttPublishingMessage(MqttMessage target, Runnable ack) {
        this.target = target;
        this.ack = ack;
    }

    public static ProxyMqttPublishingMessage of(MqttMessage target, Runnable ack) {
        return new ProxyMqttPublishingMessage(target, ack);
    }
}

