/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.core.message.codec.http;

import java.net.URL;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.codec.net.URLCodec;
import org.springframework.util.StringUtils;

public class HttpUtils {
    static final URLCodec urlCodec = new URLCodec();

    public static String urlDecode(String url) {
        return urlCodec.decode(url);
    }

    public static String urlEncode(String url) {
        return urlCodec.encode(url);
    }

    public static String getUrlPath(String url) {
        String path2 = !url.contains("://") ? url : new URL(url).getPath();
        if (!path2.startsWith("/")) {
            return "/".concat(path2);
        }
        return path2;
    }

    public static String createEncodedUrlParams(Map<?, ?> maps) {
        return maps.entrySet().stream().map(e -> HttpUtils.urlEncode(String.valueOf(e.getKey())) + "=" + HttpUtils.urlEncode(String.valueOf(e.getValue()))).collect(Collectors.joining("&"));
    }

    public static Map<String, String> parseEncodedUrlParams(String keyValueString) {
        return HttpUtils.parseEncodedUrlParams(keyValueString, LinkedHashMap::new);
    }

    public static Map<String, String> parseEncodedUrlParams(String keyValueString, Supplier<Map<String, String>> supplier) {
        if (StringUtils.isEmpty(keyValueString)) {
            return Collections.emptyMap();
        }
        return Stream.of(keyValueString.split("[&]")).map(par -> par.split("[=]", 2)).collect(Collectors.toMap(arr -> HttpUtils.urlDecode(arr[0]), arr -> ((String[])arr).length > 1 ? HttpUtils.urlDecode(arr[1]) : "", (a, b) -> String.join((CharSequence)",", a, b), supplier));
    }

    public static String appendUrlParameter(String url, Map<?, ?> param) {
        return HttpUtils.appendUrlParameter(url, HttpUtils.createEncodedUrlParams(param));
    }

    public static String appendUrlParameter(String url, String param) {
        if (StringUtils.isEmpty(url)) {
            return url;
        }
        if (url.contains("?")) {
            return url + "&" + param;
        }
        return url + "?" + param;
    }
}

