/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.core.device.session;

import java.io.Serializable;
import org.jetlinks.core.server.session.DeviceSession;

public class DeviceSessionInfo
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String deviceId;
    private String serverId;
    private String address;
    private long connectTime;
    private long lastCommTime;
    private String transport;

    public static DeviceSessionInfo of(String serverId, DeviceSession session) {
        DeviceSessionInfo sessionInfo = new DeviceSessionInfo();
        sessionInfo.setServerId(serverId);
        sessionInfo.setAddress(session.getClientAddress().map(String::valueOf).orElse(null));
        sessionInfo.setConnectTime(session.connectTime());
        sessionInfo.setDeviceId(session.getDeviceId());
        sessionInfo.setLastCommTime(session.lastPingTime());
        if (null != session.getTransport()) {
            sessionInfo.setTransport(session.getTransport().getId());
        }
        return sessionInfo;
    }

    public String getDeviceId() {
        return this.deviceId;
    }

    public String getServerId() {
        return this.serverId;
    }

    public String getAddress() {
        return this.address;
    }

    public long getConnectTime() {
        return this.connectTime;
    }

    public long getLastCommTime() {
        return this.lastCommTime;
    }

    public String getTransport() {
        return this.transport;
    }

    public void setDeviceId(String deviceId) {
        this.deviceId = deviceId;
    }

    public void setServerId(String serverId) {
        this.serverId = serverId;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public void setConnectTime(long connectTime) {
        this.connectTime = connectTime;
    }

    public void setLastCommTime(long lastCommTime) {
        this.lastCommTime = lastCommTime;
    }

    public void setTransport(String transport) {
        this.transport = transport;
    }
}

