/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.validator.internal.engine.valueextraction;

import javafx.beans.property.ListProperty;
import javax.validation.valueextraction.ValueExtractor;
import org.hibernate.validator.internal.IgnoreForbiddenApisErrors;
import org.hibernate.validator.internal.engine.valueextraction.ValueExtractorDescriptor;

@IgnoreForbiddenApisErrors(reason="Usage of JavaFX classes")
class ListPropertyValueExtractor
implements ValueExtractor<ListProperty<?>> {
    static final ValueExtractorDescriptor DESCRIPTOR = new ValueExtractorDescriptor(new ListPropertyValueExtractor());

    private ListPropertyValueExtractor() {
    }

    @Override
    public void extractValues(ListProperty<?> originalValue, ValueExtractor.ValueReceiver receiver) {
        for (int i2 = 0; i2 < originalValue.size(); ++i2) {
            receiver.indexedValue("<list element>", i2, originalValue.get(i2));
        }
    }
}

