/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.cli.converters;

import io.vertx.core.cli.converters.Converter;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;

public final class FromStringBasedConverter<T>
implements Converter<T> {
    public static final String FROM_STRING = "fromString";
    private final Method method;
    private final Class<T> clazz;

    private FromStringBasedConverter(Class<T> clazz, Method method2) {
        this.clazz = clazz;
        this.method = method2;
    }

    public static <T> FromStringBasedConverter<T> getIfEligible(Class<T> clazz) {
        try {
            Method method2 = clazz.getMethod(FROM_STRING, String.class);
            if (Modifier.isStatic(method2.getModifiers())) {
                if (!method2.isAccessible()) {
                    method2.setAccessible(true);
                }
                return new FromStringBasedConverter<T>(clazz, method2);
            }
            return null;
        }
        catch (NoSuchMethodException e) {
            return null;
        }
    }

    @Override
    public T fromString(String input) throws IllegalArgumentException {
        try {
            return this.clazz.cast(this.method.invoke(null, input));
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            if (e.getCause() != null) {
                throw new IllegalArgumentException(e.getCause());
            }
            throw new IllegalArgumentException(e);
        }
    }
}

