/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.demo.protocol;

import org.jetlinks.core.ProtocolSupport;
import org.jetlinks.core.Value;
import org.jetlinks.core.defaults.CompositeProtocolSupport;
import org.jetlinks.core.device.AuthenticationResponse;
import org.jetlinks.core.device.DeviceRegistry;
import org.jetlinks.core.device.MqttAuthenticationRequest;
import org.jetlinks.core.message.codec.DefaultTransport;
import org.jetlinks.core.message.codec.Transport;
import org.jetlinks.core.metadata.ConfigMetadata;
import org.jetlinks.core.metadata.DataType;
import org.jetlinks.core.metadata.DefaultConfigMetadata;
import org.jetlinks.core.metadata.DeviceMetadataCodec;
import org.jetlinks.core.metadata.types.PasswordType;
import org.jetlinks.core.metadata.types.StringType;
import org.jetlinks.core.spi.ProtocolSupportProvider;
import org.jetlinks.core.spi.ServiceContext;
import org.jetlinks.demo.protocol.DemoDeviceMessageCodec;
import org.jetlinks.demo.protocol.tcp.DemoTcpMessageCodec;
import org.jetlinks.supports.official.JetLinksDeviceMetadataCodec;
import reactor.core.publisher.Mono;

public class DemoProtocolSupportProvider
implements ProtocolSupportProvider {
    private static final DefaultConfigMetadata mqttConfig = new DefaultConfigMetadata("MQTT\u8ba4\u8bc1\u914d\u7f6e", "").add("username", "username", "MQTT\u7528\u6237\u540d", (DataType)new StringType()).add("password", "password", "MQTT\u5bc6\u7801", (DataType)new PasswordType());
    private static final DefaultConfigMetadata tcpConfig = new DefaultConfigMetadata("TCP\u8ba4\u8bc1\u914d\u7f6e", "").add("tcp_auth_key", "key", "TCP\u8ba4\u8bc1KEY", (DataType)new StringType());

    public Mono<? extends ProtocolSupport> create(ServiceContext context) {
        CompositeProtocolSupport support = new CompositeProtocolSupport();
        support.setId("demo-v1");
        support.setName("\u6f14\u793a\u534f\u8baev1");
        support.setDescription("\u6f14\u793a\u534f\u8bae");
        support.setMetadataCodec((DeviceMetadataCodec)new JetLinksDeviceMetadataCodec());
        context.getService(DeviceRegistry.class).ifPresent(deviceRegistry -> {
            DemoTcpMessageCodec codec = new DemoTcpMessageCodec((DeviceRegistry)deviceRegistry);
            support.addMessageCodecSupport((Transport)DefaultTransport.TCP, () -> Mono.just((Object)codec));
            support.addMessageCodecSupport((Transport)DefaultTransport.TCP_TLS, () -> Mono.just((Object)codec));
        });
        support.addConfigMetadata((Transport)DefaultTransport.TCP, (ConfigMetadata)tcpConfig);
        support.addConfigMetadata((Transport)DefaultTransport.TCP_TLS, (ConfigMetadata)tcpConfig);
        DemoDeviceMessageCodec codec = new DemoDeviceMessageCodec();
        support.addMessageCodecSupport((Transport)DefaultTransport.MQTT, () -> Mono.just((Object)codec));
        support.addConfigMetadata((Transport)DefaultTransport.MQTT, (ConfigMetadata)mqttConfig);
        support.addAuthenticator((Transport)DefaultTransport.MQTT, (request, device) -> {
            MqttAuthenticationRequest mqttRequest = (MqttAuthenticationRequest)request;
            return device.getConfigs(new String[]{"username", "password"}).flatMap(values -> {
                String username = values.getValue("username").map(Value::asString).orElse(null);
                String password = values.getValue("password").map(Value::asString).orElse(null);
                if (mqttRequest.getUsername().equals(username) && mqttRequest.getPassword().equals(password)) {
                    return Mono.just((Object)AuthenticationResponse.success());
                }
                return Mono.just((Object)AuthenticationResponse.error((int)400, (String)"\u5bc6\u7801\u9519\u8bef"));
            });
        });
        return Mono.just((Object)support);
    }
}

