/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.demo.protocol;

import com.alibaba.fastjson.JSONObject;
import java.util.HashMap;
import java.util.Map;
import org.hswebframework.web.id.IDGenerator;
import org.jetlinks.core.message.CommonDeviceMessage;
import org.jetlinks.core.message.DeviceOfflineMessage;
import org.jetlinks.core.message.DeviceOnlineMessage;
import org.jetlinks.core.message.Message;
import org.jetlinks.core.message.event.EventMessage;
import org.jetlinks.core.message.function.FunctionInvokeMessageReply;
import org.jetlinks.core.message.property.ReadPropertyMessageReply;
import org.jetlinks.core.message.property.ReportPropertyMessage;
import org.jetlinks.core.message.property.WritePropertyMessageReply;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DemoTopicMessageCodec {
    private static final Logger log = LoggerFactory.getLogger(DemoTopicMessageCodec.class);

    protected Message doEncode(String topic, JSONObject payload) {
        EventMessage message = null;
        if (topic.startsWith("/fire_alarm")) {
            message = this.handleFireAlarm(topic, payload);
        } else if (topic.startsWith("/fault_alarm")) {
            message = this.handleFaultAlarm(topic, payload);
        } else if (topic.startsWith("/dev_msg")) {
            message = this.handleDeviceMessage(topic, payload);
        } else if (topic.startsWith("/device_online_status")) {
            message = this.handleDeviceOnlineStatus(topic, payload);
        } else if (topic.startsWith("/read-property")) {
            message = this.handleReadPropertyReply(payload);
        } else if (topic.startsWith("/report-property")) {
            message = this.handleReportProperty(payload);
        } else if (topic.startsWith("/write-property")) {
            message = this.handleWritePropertyReply(payload);
        } else if (topic.startsWith("/invoke-function")) {
            message = this.handleFunctionInvokeReply(payload);
        }
        log.info("handle demo message:{}:{}", (Object)topic, (Object)payload);
        return message;
    }

    private FunctionInvokeMessageReply handleFunctionInvokeReply(JSONObject json) {
        FunctionInvokeMessageReply reply = new FunctionInvokeMessageReply();
        reply.setFunctionId(json.getString("functionId"));
        reply.setMessageId(json.getString("messageId"));
        reply.setDeviceId(json.getString("deviceId"));
        reply.setOutput(json.get((Object)"output"));
        reply.setCode(json.getString("code"));
        reply.setTimestamp(json.getLong("timestamp").longValue());
        reply.setSuccess(json.getBoolean("success").booleanValue());
        return reply;
    }

    private ReportPropertyMessage handleReportProperty(JSONObject json) {
        ReportPropertyMessage reply = new ReportPropertyMessage();
        reply.setProperties((Map)json.getJSONObject("properties"));
        reply.setMessageId((String)IDGenerator.SNOW_FLAKE_STRING.generate());
        reply.setDeviceId(json.getString("deviceId"));
        reply.setTimestamp(json.getLong("timestamp").longValue());
        reply.setSuccess(json.getBoolean("success").booleanValue());
        return reply;
    }

    private ReadPropertyMessageReply handleReadPropertyReply(JSONObject json) {
        ReadPropertyMessageReply reply = new ReadPropertyMessageReply();
        reply.setProperties((Map)json.getJSONObject("properties"));
        reply.setMessageId(json.getString("messageId"));
        reply.setTimestamp(json.getLong("timestamp").longValue());
        reply.setDeviceId(json.getString("deviceId"));
        reply.setSuccess(json.getBoolean("success").booleanValue());
        return reply;
    }

    private WritePropertyMessageReply handleWritePropertyReply(JSONObject json) {
        WritePropertyMessageReply reply = new WritePropertyMessageReply();
        reply.setProperties((Map)json.getJSONObject("properties"));
        reply.setMessageId(json.getString("messageId"));
        reply.setTimestamp(json.getLong("timestamp").longValue());
        reply.setDeviceId(json.getString("deviceId"));
        reply.setSuccess(json.getBoolean("success").booleanValue());
        return reply;
    }

    private EventMessage handleFireAlarm(String topic, JSONObject json) {
        EventMessage eventMessage = new EventMessage();
        eventMessage.setDeviceId(json.getString("deviceId"));
        eventMessage.setEvent("fire_alarm");
        eventMessage.setMessageId((String)IDGenerator.SNOW_FLAKE_STRING.generate());
        eventMessage.setData(new HashMap(json));
        eventMessage.setSuccess(true);
        return eventMessage;
    }

    private EventMessage handleFaultAlarm(String topic, JSONObject json) {
        EventMessage eventMessage = new EventMessage();
        eventMessage.setDeviceId(json.getString("deviceId"));
        eventMessage.setEvent("fault_alarm");
        eventMessage.setMessageId((String)IDGenerator.SNOW_FLAKE_STRING.generate());
        eventMessage.setData(new HashMap(json));
        eventMessage.setSuccess(true);
        return eventMessage;
    }

    private EventMessage handleDeviceMessage(String topic, JSONObject json) {
        EventMessage eventMessage = new EventMessage();
        eventMessage.setDeviceId(json.getString("deviceId"));
        eventMessage.setEvent("dev_msg");
        eventMessage.setMessageId((String)IDGenerator.SNOW_FLAKE_STRING.generate());
        eventMessage.setData(new HashMap(json));
        return eventMessage;
    }

    private CommonDeviceMessage handleDeviceOnlineStatus(String topic, JSONObject json) {
        Object deviceMessage = "1".equals(json.getString("status")) ? new DeviceOnlineMessage() : new DeviceOfflineMessage();
        deviceMessage.setDeviceId(json.getString("dno"));
        return deviceMessage;
    }
}

