/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.core.config;

import java.util.Collection;
import java.util.Map;
import org.jetlinks.core.Configurable;
import org.jetlinks.core.Value;
import org.jetlinks.core.Values;
import org.jetlinks.core.config.ConfigStorage;
import reactor.core.publisher.Mono;

public interface StorageConfigurable
extends Configurable {
    public Mono<ConfigStorage> getReactiveStorage();

    default public Mono<? extends Configurable> getParent() {
        return Mono.empty();
    }

    @Override
    default public Mono<Value> getConfig(String key) {
        return this.getConfig(key, true);
    }

    default public Mono<Value> getConfig(String key, boolean fallbackParent) {
        if (fallbackParent) {
            return this.getReactiveStorage().flatMap(store -> store.getConfig(key)).switchIfEmpty(Mono.defer(() -> this.getParent().flatMap(parent -> parent.getConfig(key))));
        }
        return this.getReactiveStorage().flatMap(store -> store.getConfig(key));
    }

    default public Mono<Values> getConfigs(Collection<String> keys, boolean fallbackParent) {
        return this.getReactiveStorage().flatMap(store -> store.getConfigs(keys)).flatMap(values -> {
            if (!keys.isEmpty() && values.size() != keys.size() && fallbackParent) {
                Collection<String> nonExistent = values.getNonExistentKeys(keys);
                return this.getParent().flatMap(parent -> parent.getConfigs(nonExistent)).map(parentValues -> parentValues.merge((Values)values)).defaultIfEmpty((Values)values);
            }
            return Mono.just(values);
        });
    }

    @Override
    default public Mono<Values> getConfigs(Collection<String> keys) {
        return this.getConfigs(keys, true);
    }

    @Override
    default public Mono<Boolean> setConfig(String key, Object value) {
        return this.getReactiveStorage().flatMap(store -> store.setConfig(key, value));
    }

    @Override
    default public Mono<Boolean> setConfigs(Map<String, Object> conf) {
        return this.getReactiveStorage().flatMap(storage -> storage.setConfigs(conf));
    }

    @Override
    default public Mono<Boolean> removeConfig(String key) {
        return this.getReactiveStorage().flatMap(storage -> storage.remove(key));
    }

    @Override
    default public Mono<Value> getAndRemoveConfig(String key) {
        return this.getReactiveStorage().flatMap(storage -> storage.getAndRemove(key));
    }

    @Override
    default public Mono<Boolean> removeConfigs(Collection<String> key) {
        return this.getReactiveStorage().flatMap(storage -> storage.remove(key));
    }

    @Override
    default public Mono<Void> refreshConfig(Collection<String> keys) {
        return this.getReactiveStorage().flatMap(storage -> storage.refresh(keys));
    }

    @Override
    default public Mono<Void> refreshAllConfig() {
        return this.getReactiveStorage().flatMap(ConfigStorage::refresh);
    }
}

