/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.demo.protocol.tcp.message;

import java.util.Arrays;
import org.jetlinks.core.utils.BytesUtils;
import org.jetlinks.demo.protocol.tcp.TcpPayload;

public class AuthRequest
implements TcpPayload {
    private long deviceId;
    private byte[] key;

    public static AuthRequest of(long deviceId, String key) {
        return new AuthRequest(deviceId, key.getBytes());
    }

    public static AuthRequest of(byte[] data) {
        AuthRequest message = new AuthRequest();
        message.fromBytes(data, 0);
        return message;
    }

    @Override
    public byte[] toBytes() {
        byte[] keyBytes = this.key == null ? new byte[]{} : this.key;
        byte[] idBytes = BytesUtils.toHighBytes((long)this.deviceId);
        byte[] data = Arrays.copyOf(idBytes, keyBytes.length + idBytes.length);
        System.arraycopy(keyBytes, 0, data, idBytes.length, keyBytes.length);
        return data;
    }

    @Override
    public void fromBytes(byte[] bytes, int offset) {
        this.deviceId = BytesUtils.highBytesToLong((byte[])bytes, (int)offset, (int)8);
        this.key = Arrays.copyOfRange(bytes, offset + 8, bytes.length);
    }

    public String toString() {
        return "{deviceId=" + this.deviceId + ", key=" + new String(this.key) + '}';
    }

    public long getDeviceId() {
        return this.deviceId;
    }

    public byte[] getKey() {
        return this.key;
    }

    public void setDeviceId(long deviceId) {
        this.deviceId = deviceId;
    }

    public void setKey(byte[] key) {
        this.key = key;
    }

    public AuthRequest(long deviceId, byte[] key) {
        this.deviceId = deviceId;
        this.key = key;
    }

    public AuthRequest() {
    }
}

