/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.demo.protocol.tcp;

import java.util.Optional;
import java.util.function.Supplier;
import org.jetlinks.demo.protocol.tcp.TcpPayload;
import org.jetlinks.demo.protocol.tcp.message.AuthRequest;
import org.jetlinks.demo.protocol.tcp.message.AuthResponse;
import org.jetlinks.demo.protocol.tcp.message.ErrorMessage;
import org.jetlinks.demo.protocol.tcp.message.FireAlarm;
import org.jetlinks.demo.protocol.tcp.message.Ping;
import org.jetlinks.demo.protocol.tcp.message.Pong;
import org.jetlinks.demo.protocol.tcp.message.TemperatureReport;

public enum MessageType {
    AUTH_REQ("\u8ba4\u8bc1\u8bf7\u6c42", AuthRequest::new),
    AUTH_RES("\u8ba4\u8bc1\u7ed3\u679c", AuthResponse::new),
    ERROR("\u9519\u8bef", ErrorMessage::new),
    PING("Ping", Ping::new),
    PONG("Pong", Pong::new),
    REPORT_TEMPERATURE("\u4e0a\u62a5\u6e29\u5ea6", TemperatureReport::new),
    FIRE_ALARM("\u706b\u8b66", FireAlarm::new);

    private String text;
    private Supplier<TcpPayload> payloadSupplier;

    public TcpPayload read(byte[] payload, int offset) {
        TcpPayload tcpPayload = this.payloadSupplier.get();
        tcpPayload.fromBytes(payload, offset);
        return tcpPayload;
    }

    public byte[] toBytes(TcpPayload data) {
        if (data == null) {
            return new byte[0];
        }
        return data.toBytes();
    }

    public static Optional<MessageType> of(byte[] payload) {
        byte type = payload[0];
        MessageType[] values = MessageType.values();
        if (type > values.length) {
            return Optional.empty();
        }
        return Optional.of(MessageType.values()[type]);
    }

    private MessageType(String text, Supplier<TcpPayload> payloadSupplier) {
        this.text = text;
        this.payloadSupplier = payloadSupplier;
    }

    public String getText() {
        return this.text;
    }

    public Supplier<TcpPayload> getPayloadSupplier() {
        return this.payloadSupplier;
    }
}

