/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.demo.protocol.tcp;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.Arrays;
import org.jetlinks.core.utils.BytesUtils;
import org.jetlinks.demo.protocol.tcp.MessageType;
import org.jetlinks.demo.protocol.tcp.TcpPayload;

public class DemoTcpMessage {
    private MessageType type;
    private TcpPayload data;

    public static DemoTcpMessage of(byte[] payload) {
        MessageType type = MessageType.of(payload).orElseThrow(IllegalArgumentException::new);
        return DemoTcpMessage.of(type, type.read(payload, 5));
    }

    public ByteBuf toByteBuf() {
        return Unpooled.wrappedBuffer((byte[])this.toBytes());
    }

    public byte[] toBytes() {
        byte[] header = new byte[5];
        header[0] = (byte)this.type.ordinal();
        byte[] body = this.type.toBytes(this.data);
        int bodyLength = body.length;
        BytesUtils.toHighBytes((byte[])header, (long)bodyLength, (int)1, (int)4);
        if (bodyLength == 0) {
            return header;
        }
        byte[] data = Arrays.copyOf(header, bodyLength + 5);
        System.arraycopy(body, 0, data, 5, bodyLength);
        return data;
    }

    public String toString() {
        return "TcpMessage{type=" + (Object)((Object)this.type) + ", data=" + this.data + '}';
    }

    public MessageType getType() {
        return this.type;
    }

    public TcpPayload getData() {
        return this.data;
    }

    public void setType(MessageType type) {
        this.type = type;
    }

    public void setData(TcpPayload data) {
        this.data = data;
    }

    private DemoTcpMessage(MessageType type, TcpPayload data) {
        this.type = type;
        this.data = data;
    }

    public static DemoTcpMessage of(MessageType type, TcpPayload data) {
        return new DemoTcpMessage(type, data);
    }
}

