/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.demo.protocol;

import com.alibaba.fastjson.JSONObject;
import java.util.HashMap;
import java.util.Map;
import org.hswebframework.web.id.IDGenerator;
import org.jetlinks.core.message.ChildDeviceMessage;
import org.jetlinks.core.message.CommonDeviceMessage;
import org.jetlinks.core.message.DeviceMessage;
import org.jetlinks.core.message.DeviceOfflineMessage;
import org.jetlinks.core.message.DeviceOnlineMessage;
import org.jetlinks.core.message.DeviceRegisterMessage;
import org.jetlinks.core.message.DeviceUnRegisterMessage;
import org.jetlinks.core.message.Message;
import org.jetlinks.core.message.event.EventMessage;
import org.jetlinks.core.message.function.FunctionInvokeMessage;
import org.jetlinks.core.message.function.FunctionInvokeMessageReply;
import org.jetlinks.core.message.property.ReadPropertyMessage;
import org.jetlinks.core.message.property.ReadPropertyMessageReply;
import org.jetlinks.core.message.property.ReportPropertyMessage;
import org.jetlinks.core.message.property.WritePropertyMessage;
import org.jetlinks.core.message.property.WritePropertyMessageReply;
import org.jetlinks.demo.protocol.TopicMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DemoTopicMessageCodec {
    private static final Logger log = LoggerFactory.getLogger(DemoTopicMessageCodec.class);

    protected DeviceMessage doDecode(String deviceId, String topic, JSONObject payload) {
        EventMessage message = null;
        if (topic.startsWith("/fire_alarm")) {
            message = this.handleFireAlarm(topic, payload);
        } else if (topic.startsWith("/fault_alarm")) {
            message = this.handleFaultAlarm(topic, payload);
        } else if (topic.startsWith("/register")) {
            message = this.handleRegister(payload);
        } else if (topic.startsWith("/unregister")) {
            message = this.handleUnRegister(payload);
        } else if (topic.startsWith("/dev_msg")) {
            message = this.handleDeviceMessage(topic, payload);
        } else if (topic.startsWith("/device_online_status")) {
            message = this.handleDeviceOnlineStatus(topic, payload);
        } else if (topic.startsWith("/read-property")) {
            message = this.handleReadPropertyReply(payload);
        } else if (topic.startsWith("/report-property")) {
            message = this.handleReportProperty(payload);
        } else if (topic.startsWith("/write-property")) {
            message = this.handleWritePropertyReply(payload);
        } else if (topic.startsWith("/invoke-function")) {
            message = this.handleFunctionInvokeReply(payload);
        } else if (topic.startsWith("/children")) {
            ChildDeviceMessage childDeviceMessage = new ChildDeviceMessage();
            childDeviceMessage.setDeviceId(deviceId);
            DeviceMessage children = this.doDecode(deviceId, topic.substring(9), payload);
            childDeviceMessage.setChildDeviceMessage((Message)children);
            childDeviceMessage.setChildDeviceId(children.getDeviceId());
            message = childDeviceMessage;
        }
        log.info("handle demo message:{}:{}", (Object)topic, (Object)payload);
        return message;
    }

    protected TopicMessage doEncode(DeviceMessage message) {
        if (message instanceof ReadPropertyMessage) {
            String topic = "/read-property";
            JSONObject data = new JSONObject();
            data.put("messageId", (Object)message.getMessageId());
            data.put("deviceId", (Object)message.getDeviceId());
            data.put("properties", (Object)((ReadPropertyMessage)message).getProperties());
            return new TopicMessage(topic, data);
        }
        if (message instanceof WritePropertyMessage) {
            String topic = "/write-property";
            JSONObject data = new JSONObject();
            data.put("messageId", (Object)message.getMessageId());
            data.put("deviceId", (Object)message.getDeviceId());
            data.put("properties", (Object)((WritePropertyMessage)message).getProperties());
            return new TopicMessage(topic, data);
        }
        if (message instanceof FunctionInvokeMessage) {
            String topic = "/invoke-function";
            FunctionInvokeMessage invokeMessage = (FunctionInvokeMessage)message;
            JSONObject data = new JSONObject();
            data.put("messageId", (Object)message.getMessageId());
            data.put("deviceId", (Object)message.getDeviceId());
            data.put("function", (Object)invokeMessage.getFunctionId());
            data.put("args", (Object)invokeMessage.getInputs());
            return new TopicMessage(topic, data);
        }
        if (message instanceof ChildDeviceMessage) {
            TopicMessage msg = this.doEncode((DeviceMessage)((ChildDeviceMessage)message).getChildDeviceMessage());
            if (msg == null) {
                return null;
            }
            String topic = "/children" + msg.getTopic();
            return new TopicMessage(topic, msg.getMessage());
        }
        return null;
    }

    private FunctionInvokeMessageReply handleFunctionInvokeReply(JSONObject json) {
        FunctionInvokeMessageReply reply = new FunctionInvokeMessageReply();
        reply.setFunctionId(json.getString("functionId"));
        reply.setMessageId(json.getString("messageId"));
        reply.setDeviceId(json.getString("deviceId"));
        reply.setOutput(json.get((Object)"output"));
        reply.setCode(json.getString("code"));
        reply.setTimestamp(json.getLong("timestamp").longValue());
        reply.setSuccess(json.getBoolean("success").booleanValue());
        return reply;
    }

    private DeviceRegisterMessage handleRegister(JSONObject json) {
        DeviceRegisterMessage reply = new DeviceRegisterMessage();
        reply.setMessageId((String)IDGenerator.SNOW_FLAKE_STRING.generate());
        reply.setDeviceId(json.getString("deviceId"));
        reply.setTimestamp(System.currentTimeMillis());
        return reply;
    }

    private DeviceUnRegisterMessage handleUnRegister(JSONObject json) {
        DeviceUnRegisterMessage reply = new DeviceUnRegisterMessage();
        reply.setMessageId((String)IDGenerator.SNOW_FLAKE_STRING.generate());
        reply.setDeviceId(json.getString("deviceId"));
        reply.setTimestamp(System.currentTimeMillis());
        return reply;
    }

    private ReportPropertyMessage handleReportProperty(JSONObject json) {
        ReportPropertyMessage reply = new ReportPropertyMessage();
        reply.setProperties((Map)json.getJSONObject("properties"));
        reply.setMessageId((String)IDGenerator.SNOW_FLAKE_STRING.generate());
        reply.setDeviceId(json.getString("deviceId"));
        reply.setTimestamp(json.getLong("timestamp").longValue());
        return reply;
    }

    private ReadPropertyMessageReply handleReadPropertyReply(JSONObject json) {
        ReadPropertyMessageReply reply = new ReadPropertyMessageReply();
        reply.setProperties((Map)json.getJSONObject("properties"));
        reply.setMessageId(json.getString("messageId"));
        reply.setTimestamp(json.getLong("timestamp").longValue());
        reply.setDeviceId(json.getString("deviceId"));
        reply.setSuccess(json.getBoolean("success").booleanValue());
        return reply;
    }

    private WritePropertyMessageReply handleWritePropertyReply(JSONObject json) {
        WritePropertyMessageReply reply = new WritePropertyMessageReply();
        reply.setProperties((Map)json.getJSONObject("properties"));
        reply.setMessageId(json.getString("messageId"));
        reply.setTimestamp(json.getLong("timestamp").longValue());
        reply.setDeviceId(json.getString("deviceId"));
        reply.setSuccess(json.getBoolean("success").booleanValue());
        return reply;
    }

    private EventMessage handleFireAlarm(String topic, JSONObject json) {
        EventMessage eventMessage = new EventMessage();
        eventMessage.setDeviceId(json.getString("deviceId"));
        eventMessage.setEvent("fire_alarm");
        eventMessage.setMessageId((String)IDGenerator.SNOW_FLAKE_STRING.generate());
        eventMessage.setData(new HashMap(json));
        return eventMessage;
    }

    private EventMessage handleFaultAlarm(String topic, JSONObject json) {
        EventMessage eventMessage = new EventMessage();
        eventMessage.setDeviceId(json.getString("deviceId"));
        eventMessage.setEvent("fault_alarm");
        eventMessage.setMessageId((String)IDGenerator.SNOW_FLAKE_STRING.generate());
        eventMessage.setData(new HashMap(json));
        return eventMessage;
    }

    private EventMessage handleDeviceMessage(String topic, JSONObject json) {
        EventMessage eventMessage = new EventMessage();
        eventMessage.setDeviceId(json.getString("deviceId"));
        eventMessage.setEvent("dev_msg");
        eventMessage.setMessageId((String)IDGenerator.SNOW_FLAKE_STRING.generate());
        eventMessage.setData(new HashMap(json));
        return eventMessage;
    }

    private CommonDeviceMessage handleDeviceOnlineStatus(String topic, JSONObject json) {
        Object deviceMessage = "1".equals(json.getString("status")) ? new DeviceOnlineMessage() : new DeviceOfflineMessage();
        deviceMessage.setDeviceId(json.getString("deviceId"));
        return deviceMessage;
    }
}

