/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.simulator.cmd.benchmark;

import java.net.URL;
import java.util.Collections;
import java.util.Map;
import org.jetlinks.simulator.cmd.NetClientCommandOption;
import org.jetlinks.simulator.cmd.benchmark.AbstractBenchmarkCommand;
import org.jetlinks.simulator.core.Connection;
import org.jetlinks.simulator.core.benchmark.ConnectCreateContext;
import org.jetlinks.simulator.core.network.http.HTTPClient;
import org.jetlinks.simulator.core.network.http.HTTPClientOptions;
import org.springframework.http.HttpHeaders;
import picocli.CommandLine;
import reactor.core.publisher.Mono;

@CommandLine.Command(name="http", showDefaultValues=true, description={"Create HTTP Benchmark"}, headerHeading="%n", sortOptions=false)
class HTTPBenchMark
extends AbstractBenchmarkCommand
implements Runnable {
    @CommandLine.Mixin
    CommandOptions command;
    @CommandLine.Mixin
    NetClientCommandOption common;

    HTTPBenchMark() {
    }

    @Override
    protected Mono<? extends Connection> createConnection(ConnectCreateContext ctx) {
        HTTPClientOptions commandOptions = this.command.refactor(Collections.singletonMap("index", ctx.index()));
        if (null != this.common) {
            this.common.apply(commandOptions);
        }
        ctx.beforeConnect(commandOptions);
        return HTTPClient.create(commandOptions);
    }

    static class CommandOptions
    extends HTTPClientOptions {
        CommandOptions() {
        }

        @Override
        @CommandLine.Option(names={"--id"}, description={"ID"}, defaultValue="http-client-{index}", order=1)
        public void setId(String id) {
            super.setId(id);
        }

        @CommandLine.Option(names={"-h", "--header"}, description={"Default Headers"})
        public void setHeader(Map<String, String> header) {
            HttpHeaders headers2 = new HttpHeaders();
            header.forEach(headers2::add);
            this.setHeaders(headers2);
        }

        @CommandLine.Option(names={"-u", "--url"}, description={"Request Base URL"})
        public void setBasePath(URL basePath) {
            super.setBasePath(basePath.toString());
        }

        @CommandLine.Option(names={"--shared"}, description={"Shared Client"}, defaultValue="false")
        public void setShared0(boolean shared) {
            super.setShared(shared);
        }
    }
}

