/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.core.utils;

import java.util.function.Predicate;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.core.publisher.Sinks;
import reactor.util.concurrent.Queues;
import reactor.util.context.ContextView;

public interface Reactors {
    public static final Mono<Boolean> ALWAYS_TRUE = Mono.just(true);
    public static final Mono<Boolean> ALWAYS_FALSE = Mono.just(false);
    public static final Mono<Integer> ALWAYS_ZERO = Mono.just(0);
    public static final Mono<Integer> ALWAYS_ONE = Mono.just(1);
    public static final Mono<Long> ALWAYS_ONE_LONG = Mono.just(1L);
    public static final Mono<Long> ALWAYS_ZERO_LONG = Mono.just(0L);
    public static final Sinks.EmitFailureHandler RETRY_NON_SERIALIZED = (signal, failure) -> failure == Sinks.EmitResult.FAIL_NON_SERIALIZED;

    public static Sinks.EmitFailureHandler emitFailureHandler() {
        return RETRY_NON_SERIALIZED;
    }

    public static Sinks.EmitFailureHandler retryNonSerialized() {
        return RETRY_NON_SERIALIZED;
    }

    public static <T> Sinks.Many<T> createMany(int bufferSize, boolean autoCancel) {
        return Sinks.many().multicast().onBackpressureBuffer(bufferSize, autoCancel);
    }

    public static <T> Sinks.Many<T> createMany(boolean autoCancel) {
        return Reactors.createMany(Queues.SMALL_BUFFER_SIZE, autoCancel);
    }

    public static <T> Sinks.Many<T> createMany() {
        return Reactors.createMany(false);
    }

    public static <T> Flux<T> doWhenContext(Predicate<ContextView> predicate, Flux<T> flux) {
        return Flux.deferContextual(ctx -> {
            if (predicate.test((ContextView)ctx)) {
                return flux;
            }
            return Flux.empty();
        });
    }

    public static <T> Mono<T> doWhenContext(Predicate<ContextView> predicate, Mono<T> mono) {
        return Mono.deferContextual(ctx -> {
            if (predicate.test((ContextView)ctx)) {
                return mono;
            }
            return Mono.empty();
        });
    }
}

