/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.core.message.codec.http;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nonnull;
import org.jetlinks.core.message.codec.EncodedMessage;
import org.jetlinks.core.message.codec.http.Header;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;

public interface HttpResponseMessage
extends EncodedMessage {
    public int getStatus();

    public MediaType getContentType();

    @Nonnull
    public List<Header> getHeaders();

    default public Optional<Header> getHeader(String name) {
        return this.getHeaders().stream().filter(header -> header.getName().equals(name)).findFirst();
    }

    default public String print() {
        ByteBuf payload;
        StringBuilder builder = new StringBuilder();
        builder.append("HTTP").append(" ").append((Object)HttpStatus.resolve(this.getStatus())).append("\n");
        boolean hasContentType = false;
        for (Header header : this.getHeaders()) {
            if ("Content-Type".equals(header.getName())) {
                hasContentType = true;
            }
            builder.append(header.getName()).append(": ").append(String.join((CharSequence)",", header.getValue())).append("\n");
        }
        if (!hasContentType && null != this.getContentType()) {
            builder.append("Content-Type: ").append(this.getContentType()).append("\n");
        }
        if ((payload = this.getPayload()).readableBytes() == 0) {
            return builder.toString();
        }
        builder.append("\n");
        if (ByteBufUtil.isText(payload, StandardCharsets.UTF_8)) {
            builder.append(payload.toString(StandardCharsets.UTF_8));
        } else {
            ByteBufUtil.appendPrettyHexDump(builder, payload);
        }
        return builder.toString();
    }
}

