/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.core.defaults;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import org.jetlinks.core.Configurable;
import org.jetlinks.core.Value;
import org.jetlinks.core.Values;
import org.jetlinks.core.config.ConfigStorage;
import org.jetlinks.core.config.ConfigStorageManager;
import org.jetlinks.core.config.StorageConfigurable;
import org.jetlinks.core.device.DeviceConfigKey;
import org.jetlinks.core.things.Thing;
import org.jetlinks.core.things.ThingMetadata;
import org.jetlinks.core.things.ThingMetadataCodec;
import org.jetlinks.core.things.ThingRpcSupport;
import org.jetlinks.core.things.ThingTemplate;
import org.jetlinks.core.things.ThingType;
import org.jetlinks.core.things.ThingsConfigKeys;
import org.jetlinks.core.things.ThingsRegistry;
import reactor.core.publisher.Mono;

class DefaultThing
implements Thing,
StorageConfigurable {
    private final String id;
    private final ThingType type;
    private final Mono<ConfigStorage> storageMono;
    private final Mono<ThingMetadata> metadataMono;
    private final Mono<ThingTemplate> templateMono;
    private volatile long lastMetadataTime = -1L;
    private volatile ThingMetadata metadataCache;
    private final ThingMetadataCodec metadataCodec;
    private final Function<Thing, ThingRpcSupport> rpcFactory;

    public DefaultThing(ThingType thingType, String id, ConfigStorageManager storageManager, ThingMetadataCodec metadataCodec, ThingsRegistry registry, Function<Thing, ThingRpcSupport> rpcFactory) {
        this(thingType, id, storageManager.getStorage("thing:" + thingType.getId() + ":" + id), metadataCodec, registry, rpcFactory);
    }

    public DefaultThing(ThingType thingType, String id, Mono<ConfigStorage> storageSupplier, ThingMetadataCodec metadataCodec, ThingsRegistry registry, Function<Thing, ThingRpcSupport> rpcFactory) {
        this.id = id;
        this.type = thingType;
        this.storageMono = storageSupplier;
        this.metadataCodec = metadataCodec;
        this.rpcFactory = rpcFactory;
        this.templateMono = this.getSelfConfig(ThingsConfigKeys.templateId).flatMap(templateId -> registry.getTemplate(this.type, (String)templateId));
        this.metadataMono = this.getSelfConfig(ThingsConfigKeys.lastMetadataTimeKey.getKey()).map(Value::asLong).flatMap(i2 -> {
            if (i2.equals(this.lastMetadataTime) && this.metadataCache != null) {
                return Mono.just(this.metadataCache);
            }
            this.lastMetadataTime = i2;
            return this.getSelfConfig(DeviceConfigKey.metadata).flatMap(metadataCodec::decode).doOnNext(metadata -> {
                this.metadataCache = metadata;
            });
        }).switchIfEmpty(Mono.defer(() -> this.getTemplate().flatMap(ThingTemplate::getMetadata)));
    }

    @Override
    public Mono<? extends Configurable> getParent() {
        return this.getTemplate();
    }

    @Override
    public Mono<ConfigStorage> getReactiveStorage() {
        return this.storageMono;
    }

    public Mono<ThingTemplate> getTemplate() {
        return this.templateMono;
    }

    public Mono<ThingMetadata> getMetadata() {
        return this.metadataMono;
    }

    @Override
    public Mono<Boolean> updateMetadata(String metadata) {
        HashMap<String, Object> configs = new HashMap<String, Object>();
        configs.put(DeviceConfigKey.metadata.getKey(), metadata);
        return this.setConfigs(configs);
    }

    @Override
    public Mono<Void> resetMetadata() {
        this.lastMetadataTime = -1L;
        return this.removeConfigs(DeviceConfigKey.metadata, ThingsConfigKeys.lastMetadataTimeKey).then();
    }

    @Override
    public Mono<Boolean> setConfigs(Map<String, Object> conf) {
        HashMap<String, Object> configs = new HashMap<String, Object>(conf);
        if (conf.containsKey(DeviceConfigKey.metadata.getKey())) {
            this.lastMetadataTime = System.currentTimeMillis();
            configs.put(ThingsConfigKeys.lastMetadataTimeKey.getKey(), this.lastMetadataTime);
            return StorageConfigurable.super.setConfigs(configs).doOnNext(suc -> {
                this.metadataCache = null;
            }).thenReturn(true);
        }
        return StorageConfigurable.super.setConfigs(configs);
    }

    @Override
    public Mono<Boolean> updateMetadata(ThingMetadata metadata) {
        return this.metadataCodec.encode(metadata).flatMap(this::updateMetadata);
    }

    @Override
    public Mono<Value> getSelfConfig(String key) {
        return this.getConfig(key, false);
    }

    @Override
    public Mono<Values> getSelfConfigs(Collection<String> keys) {
        return this.getConfigs(keys, false);
    }

    @Override
    public ThingRpcSupport rpc() {
        return this.rpcFactory.apply(this);
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public ThingType getType() {
        return this.type;
    }
}

