/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.core.codec.defaults;

import java.util.Arrays;
import javax.annotation.Nonnull;
import org.jetlinks.core.Payload;
import org.jetlinks.core.codec.Codec;

public class EnumCodec<T extends Enum<?>>
implements Codec<T> {
    private final T[] values;

    @Override
    public Class<T> forType() {
        return ((Enum)this.values[0]).getDeclaringClass();
    }

    @Override
    public T decode(@Nonnull Payload payload) {
        byte[] bytes = payload.getBytes(false);
        if (bytes.length > 0 && bytes[0] <= this.values.length) {
            return this.values[bytes[0] & 0xFF];
        }
        throw new IllegalArgumentException("can not decode payload " + Arrays.toString(bytes) + " to enums " + Arrays.toString(this.values));
    }

    @Override
    public Payload encode(T body2) {
        return Payload.of(new byte[]{(byte)((Enum)body2).ordinal()});
    }

    private EnumCodec(T[] values) {
        this.values = values;
    }

    public static <T extends Enum<?>> EnumCodec<T> of(T[] values) {
        return new EnumCodec(values);
    }
}

