/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.core.utils;

import com.google.common.collect.AbstractIterator;
import java.io.Serializable;
import java.util.AbstractCollection;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.jetlinks.core.utils.CompositeSet;

public class CompositeMap<K, V>
implements Map<K, V>,
Serializable {
    private static final long serialVersionUID = 1L;
    private final Map<K, V> first;
    private final Map<K, V> second;

    public CompositeMap(Map<K, V> first, Map<K, V> second) {
        this.first = first.size() >= second.size() ? first : second;
        this.second = second.size() > first.size() ? first : second;
    }

    @Override
    public int size() {
        int duplicate = 0;
        for (K e : this.second.keySet()) {
            if (!this.first.containsKey(e)) continue;
            ++duplicate;
        }
        return this.first.size() + this.second.size() - duplicate;
    }

    @Override
    public boolean isEmpty() {
        return this.first.isEmpty() && this.second.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.first.containsKey(key) || this.second.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.first.containsValue(value) || this.second.containsValue(value);
    }

    @Override
    public V get(Object key) {
        V firstValue = this.first.get(key);
        if (firstValue == null) {
            return this.second.get(key);
        }
        return firstValue;
    }

    @Override
    public V put(K key, V value) {
        throw new IllegalStateException();
    }

    @Override
    public V remove(Object key) {
        throw new IllegalStateException();
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> m3) {
        throw new IllegalStateException();
    }

    @Override
    public void clear() {
    }

    @Override
    public Set<K> keySet() {
        return new CompositeSet<K>(this.first.keySet(), this.second.keySet());
    }

    @Override
    public Collection<V> values() {
        return new ValueView();
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return new CompositeSet<Map.Entry<K, V>>(this.first.entrySet(), this.second.entrySet());
    }

    public String toString() {
        return "[" + this.first + "," + this.second + "]";
    }

    class ValueIteratorView
    extends AbstractIterator<V> {
        private final Iterator<Map.Entry<K, V>> firstIt;
        private final Iterator<Map.Entry<K, V>> secondIt;

        ValueIteratorView() {
            this.firstIt = CompositeMap.this.first.entrySet().iterator();
            this.secondIt = CompositeMap.this.second.entrySet().iterator();
        }

        @Override
        protected V computeNext() {
            if (this.secondIt.hasNext()) {
                return this.secondIt.next().getValue();
            }
            while (this.firstIt.hasNext()) {
                Map.Entry e = this.firstIt.next();
                if (CompositeMap.this.second.containsKey(e.getKey())) continue;
                return e.getValue();
            }
            return this.endOfData();
        }
    }

    class ValueView
    extends AbstractCollection<V> {
        ValueView() {
        }

        @Override
        public Iterator<V> iterator() {
            return new ValueIteratorView();
        }

        @Override
        public int size() {
            return CompositeMap.this.size();
        }
    }
}

